/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class TestClientRMProxy {
    @Test
    public void testGetRMDelegationTokenService() {
        String defaultRMAddress = "0.0.0.0:8032";
        YarnConfiguration conf = new YarnConfiguration();
        Text tokenService = ClientRMProxy.getRMDelegationTokenService((Configuration)conf);
        String[] services = tokenService.toString().split(",");
        Assert.assertEquals((long)1L, (long)services.length);
        for (String service : services) {
            Assert.assertTrue((String)"Incorrect token service name", (boolean)service.contains(defaultRMAddress));
        }
        conf.setBoolean("yarn.resourcemanager.ha.enabled", true);
        conf.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)"rm1"), "0.0.0.0");
        conf.set(HAUtil.addSuffix((String)"yarn.resourcemanager.hostname", (String)"rm2"), "0.0.0.0");
        tokenService = ClientRMProxy.getRMDelegationTokenService((Configuration)conf);
        services = tokenService.toString().split(",");
        Assert.assertEquals((long)2L, (long)services.length);
        for (String service : services) {
            Assert.assertTrue((String)"Incorrect token service name", (boolean)service.contains(defaultRMAddress));
        }
    }
}

