/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.ipc;

import com.google.protobuf.ServiceException;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.TestRPCUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestRPCUtil {
    @Test
    public void testUnknownExceptionUnwrapping() {
        Class<YarnException> exception = YarnException.class;
        String className = "UnknownException.class";
        this.verifyRemoteExceptionUnwrapping(exception, className);
    }

    @Test
    public void testRemoteIOExceptionUnwrapping() {
        Class<IOException> exception = IOException.class;
        this.verifyRemoteExceptionUnwrapping(exception, exception.getName());
    }

    @Test
    public void testRemoteIOExceptionDerivativeUnwrapping() {
        Class<FileNotFoundException> exception = FileNotFoundException.class;
        this.verifyRemoteExceptionUnwrapping(exception, exception.getName());
    }

    @Test
    public void testRemoteYarnExceptionUnwrapping() {
        Class<YarnException> exception = YarnException.class;
        this.verifyRemoteExceptionUnwrapping(exception, exception.getName());
    }

    @Test
    public void testRemoteYarnExceptionDerivativeUnwrapping() {
        Class<YarnTestException> exception = YarnTestException.class;
        this.verifyRemoteExceptionUnwrapping(exception, exception.getName());
    }

    @Test
    public void testRemoteRuntimeExceptionUnwrapping() {
        Class<NullPointerException> exception = NullPointerException.class;
        this.verifyRemoteExceptionUnwrapping(exception, exception.getName());
    }

    @Test
    public void testUnexpectedRemoteExceptionUnwrapping() {
        Class<Exception> exception = Exception.class;
        this.verifyRemoteExceptionUnwrapping(RemoteException.class, exception.getName());
    }

    @Test
    public void testRemoteYarnExceptionWithoutStringConstructor() {
        Class<YarnTestExceptionNoConstructor> exception = YarnTestExceptionNoConstructor.class;
        this.verifyRemoteExceptionUnwrapping(RemoteException.class, exception.getName());
    }

    @Test
    public void testRPCServiceExceptionUnwrapping() {
        String message = "ServiceExceptionMessage";
        ServiceException se = new ServiceException(message);
        Throwable t = null;
        try {
            RPCUtil.unwrapAndThrowException((ServiceException)se);
        }
        catch (Throwable thrown) {
            t = thrown;
        }
        Assert.assertTrue((boolean)IOException.class.isInstance(t));
        Assert.assertTrue((boolean)t.getMessage().contains(message));
    }

    @Test
    public void testRPCIOExceptionUnwrapping() {
        String message = "DirectIOExceptionMessage";
        FileNotFoundException ioException = new FileNotFoundException(message);
        ServiceException se = new ServiceException((Throwable)ioException);
        Throwable t = null;
        try {
            RPCUtil.unwrapAndThrowException((ServiceException)se);
        }
        catch (Throwable thrown) {
            t = thrown;
        }
        Assert.assertTrue((boolean)FileNotFoundException.class.isInstance(t));
        Assert.assertTrue((boolean)t.getMessage().contains(message));
    }

    @Test
    public void testRPCRuntimeExceptionUnwrapping() {
        String message = "RPCRuntimeExceptionUnwrapping";
        NullPointerException re = new NullPointerException(message);
        ServiceException se = new ServiceException((Throwable)re);
        Throwable t = null;
        try {
            RPCUtil.unwrapAndThrowException((ServiceException)se);
        }
        catch (Throwable thrown) {
            t = thrown;
        }
        Assert.assertTrue((boolean)NullPointerException.class.isInstance(t));
        Assert.assertTrue((boolean)t.getMessage().contains(message));
    }

    private void verifyRemoteExceptionUnwrapping(Class<? extends Throwable> expectedLocalException, String realExceptionClassName) {
        String message = realExceptionClassName + "Message";
        RemoteException re = new RemoteException(realExceptionClassName, message);
        ServiceException se = new ServiceException((Throwable)re);
        Throwable t = null;
        try {
            RPCUtil.unwrapAndThrowException((ServiceException)se);
        }
        catch (Throwable thrown) {
            t = thrown;
        }
        Assert.assertTrue((String)("Expected exception [" + expectedLocalException + "] but found " + t), (boolean)expectedLocalException.isInstance(t));
        Assert.assertTrue((String)("Expected message [" + message + "] but found " + t.getMessage()), (boolean)t.getMessage().contains(message));
    }
}

