/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RMNodeLabel
implements Comparable<RMNodeLabel> {
    private Resource resource;
    private int numActiveNMs;
    private String labelName;
    private Set<NodeId> nodeIds;
    private boolean exclusive;
    private NodeLabel nodeLabel;

    public RMNodeLabel(NodeLabel nodeLabel) {
        this(nodeLabel.getName(), Resource.newInstance((int)0, (int)0), 0, nodeLabel.isExclusive());
    }

    public RMNodeLabel(String labelName) {
        this(labelName, Resource.newInstance((int)0, (int)0), 0, true);
    }

    protected RMNodeLabel(String labelName, Resource res, int activeNMs, boolean exclusive) {
        this.labelName = labelName;
        this.resource = res;
        this.numActiveNMs = activeNMs;
        this.nodeIds = new HashSet<NodeId>();
        this.exclusive = exclusive;
        this.nodeLabel = NodeLabel.newInstance((String)labelName, (boolean)exclusive);
    }

    public void addNodeId(NodeId node) {
        this.nodeIds.add(node);
    }

    public void removeNodeId(NodeId node) {
        this.nodeIds.remove(node);
    }

    public Set<NodeId> getAssociatedNodeIds() {
        return new HashSet<NodeId>(this.nodeIds);
    }

    public void addNode(Resource nodeRes) {
        Resources.addTo(this.resource, nodeRes);
        ++this.numActiveNMs;
    }

    public void removeNode(Resource nodeRes) {
        Resources.subtractFrom(this.resource, nodeRes);
        --this.numActiveNMs;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int getNumActiveNMs() {
        return this.numActiveNMs;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void setIsExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean getIsExclusive() {
        return this.exclusive;
    }

    public RMNodeLabel getCopy() {
        return new RMNodeLabel(this.labelName, this.resource, this.numActiveNMs, this.exclusive);
    }

    public NodeLabel getNodeLabel() {
        return this.nodeLabel;
    }

    @Override
    public int compareTo(RMNodeLabel o) {
        if (this.labelName.isEmpty() != o.getLabelName().isEmpty()) {
            if (this.labelName.isEmpty()) {
                return -1;
            }
            return 1;
        }
        return this.labelName.compareTo(o.getLabelName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof RMNodeLabel) {
            RMNodeLabel other = (RMNodeLabel)obj;
            return Resources.equals(this.resource, other.getResource()) && StringUtils.equals((String)this.labelName, (String)other.getLabelName()) && other.getNumActiveNMs() == this.numActiveNMs;
        }
        return false;
    }

    public int hashCode() {
        int prime = 502357;
        return (int)((((long)this.labelName.hashCode() << 8) + (long)(this.resource.hashCode() << 4) + (long)this.numActiveNMs) % 502357L);
    }
}

