/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.timeline.recovery.LeveldbTimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.recovery.TimelineStateStore;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineDelegationTokenSecretManagerService
extends AbstractService {
    private TimelineDelegationTokenSecretManager secretManager = null;
    private TimelineStateStore stateStore = null;

    public TimelineDelegationTokenSecretManagerService() {
        super(TimelineDelegationTokenSecretManagerService.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (conf.getBoolean("yarn.timeline-service.recovery.enabled", false)) {
            this.stateStore = this.createStateStore(conf);
            this.stateStore.init(conf);
        }
        long secretKeyInterval = conf.getLong("yarn.timeline-service.delegation.key.update-interval", 86400000L);
        long tokenMaxLifetime = conf.getLong("yarn.timeline-service.delegation.token.max-lifetime", 604800000L);
        long tokenRenewInterval = conf.getLong("yarn.timeline-service.delegation.token.renew-interval", 86400000L);
        this.secretManager = new TimelineDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, 3600000L, this.stateStore);
        super.init(conf);
    }

    protected void serviceStart() throws Exception {
        if (this.stateStore != null) {
            this.stateStore.start();
            TimelineStateStore.TimelineServiceState state = this.stateStore.loadState();
            this.secretManager.recover(state);
        }
        this.secretManager.startThreads();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.stateStore != null) {
            this.stateStore.stop();
        }
        this.secretManager.stopThreads();
        super.stop();
    }

    protected TimelineStateStore createStateStore(Configuration conf) {
        return (TimelineStateStore)((Object)ReflectionUtils.newInstance((Class)conf.getClass("yarn.timeline-service.state-store-class", LeveldbTimelineStateStore.class, TimelineStateStore.class), (Configuration)conf));
    }

    public TimelineDelegationTokenSecretManager getTimelineDelegationTokenSecretManager() {
        return this.secretManager;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class TimelineDelegationTokenSecretManager
    extends AbstractDelegationTokenSecretManager<TimelineDelegationTokenIdentifier> {
        public static final Log LOG = LogFactory.getLog(TimelineDelegationTokenSecretManager.class);
        private TimelineStateStore stateStore;

        public TimelineDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, TimelineStateStore stateStore) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
            this.stateStore = stateStore;
        }

        public TimelineDelegationTokenIdentifier createIdentifier() {
            return new TimelineDelegationTokenIdentifier();
        }

        protected void storeNewMasterKey(DelegationKey key) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Storing master key " + key.getKeyId()));
            }
            try {
                if (this.stateStore != null) {
                    this.stateStore.storeTokenMasterKey(key);
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to store master key " + key.getKeyId()), (Throwable)e);
            }
        }

        protected void removeStoredMasterKey(DelegationKey key) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing master key " + key.getKeyId()));
            }
            try {
                if (this.stateStore != null) {
                    this.stateStore.removeTokenMasterKey(key);
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to remove master key " + key.getKeyId()), (Throwable)e);
            }
        }

        protected void storeNewToken(TimelineDelegationTokenIdentifier tokenId, long renewDate) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Storing token " + tokenId.getSequenceNumber()));
            }
            try {
                if (this.stateStore != null) {
                    this.stateStore.storeToken(tokenId, renewDate);
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to store token " + tokenId.getSequenceNumber()), (Throwable)e);
            }
        }

        protected void removeStoredToken(TimelineDelegationTokenIdentifier tokenId) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Storing token " + tokenId.getSequenceNumber()));
            }
            try {
                if (this.stateStore != null) {
                    this.stateStore.removeToken(tokenId);
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to remove token " + tokenId.getSequenceNumber()), (Throwable)e);
            }
        }

        protected void updateStoredToken(TimelineDelegationTokenIdentifier tokenId, long renewDate) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Updating token " + tokenId.getSequenceNumber()));
            }
            try {
                if (this.stateStore != null) {
                    this.stateStore.updateToken(tokenId, renewDate);
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to update token " + tokenId.getSequenceNumber()), (Throwable)e);
            }
        }

        public void recover(TimelineStateStore.TimelineServiceState state) throws IOException {
            LOG.info((Object)("Recovering " + ((Object)((Object)this)).getClass().getSimpleName()));
            for (DelegationKey delegationKey : state.getTokenMasterKeyState()) {
                this.addKey(delegationKey);
            }
            this.delegationTokenSequenceNumber = state.getLatestSequenceNumber();
            for (Map.Entry entry : state.getTokenState().entrySet()) {
                this.addPersistedDelegationToken((AbstractDelegationTokenIdentifier)entry.getKey(), (Long)entry.getValue());
            }
        }
    }
}

