/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.util.Apps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHistoryManagerOnTimelineStore
extends AbstractService
implements ApplicationHistoryManager {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationHistoryManagerOnTimelineStore.class);
    @VisibleForTesting
    static final String UNAVAILABLE = "N/A";
    private TimelineDataManager timelineDataManager;
    private ApplicationACLsManager aclsManager;
    private String serverHttpAddress;
    private long maxLoadedApplications;

    public ApplicationHistoryManagerOnTimelineStore(TimelineDataManager timelineDataManager, ApplicationACLsManager aclsManager) {
        super(ApplicationHistoryManagerOnTimelineStore.class.getName());
        this.timelineDataManager = timelineDataManager;
        this.aclsManager = aclsManager;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.serverHttpAddress = WebAppUtils.getHttpSchemePrefix((Configuration)conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf);
        this.maxLoadedApplications = conf.getLong("yarn.timeline-service.generic-application-history.max-applications", 10000L);
        super.serviceInit(conf);
    }

    @Override
    public ApplicationReport getApplication(ApplicationId appId) throws YarnException, IOException {
        return this.getApplication(appId, ApplicationReportField.ALL).appReport;
    }

    @Override
    public Map<ApplicationId, ApplicationReport> getApplications(long appsNum, long appStartedTimeBegin, long appStartedTimeEnd) throws YarnException, IOException {
        TimelineEntities entities = this.timelineDataManager.getEntities("YARN_APPLICATION", null, null, appStartedTimeBegin, appStartedTimeEnd, null, null, appsNum == Long.MAX_VALUE ? this.maxLoadedApplications : appsNum, EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        LinkedHashMap<ApplicationId, ApplicationReport> apps = new LinkedHashMap<ApplicationId, ApplicationReport>();
        if (entities != null && entities.getEntities() != null) {
            for (TimelineEntity entity : entities.getEntities()) {
                try {
                    ApplicationReportExt app = this.generateApplicationReport(entity, ApplicationReportField.ALL);
                    apps.put(app.appReport.getApplicationId(), app.appReport);
                }
                catch (Exception e) {
                    LOG.error("Error on generating application report for " + entity.getEntityId(), (Throwable)e);
                }
            }
        }
        return apps;
    }

    @Override
    public Map<ApplicationAttemptId, ApplicationAttemptReport> getApplicationAttempts(ApplicationId appId) throws YarnException, IOException {
        ApplicationReportExt app = this.getApplication(appId, ApplicationReportField.USER_AND_ACLS);
        this.checkAccess(app);
        TimelineEntities entities = this.timelineDataManager.getEntities("YARN_APPLICATION_ATTEMPT", new NameValuePair("YARN_APPLICATION_ATTEMPT_PARENT", appId.toString()), null, null, null, null, null, Long.MAX_VALUE, EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        LinkedHashMap<ApplicationAttemptId, ApplicationAttemptReport> appAttempts = new LinkedHashMap<ApplicationAttemptId, ApplicationAttemptReport>();
        for (TimelineEntity entity : entities.getEntities()) {
            ApplicationAttemptReport appAttempt = ApplicationHistoryManagerOnTimelineStore.convertToApplicationAttemptReport(entity);
            appAttempts.put(appAttempt.getApplicationAttemptId(), appAttempt);
        }
        return appAttempts;
    }

    @Override
    public ApplicationAttemptReport getApplicationAttempt(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        return this.getApplicationAttempt(appAttemptId, true);
    }

    private ApplicationAttemptReport getApplicationAttempt(ApplicationAttemptId appAttemptId, boolean checkACLs) throws YarnException, IOException {
        TimelineEntity entity;
        if (checkACLs) {
            ApplicationReportExt app = this.getApplication(appAttemptId.getApplicationId(), ApplicationReportField.USER_AND_ACLS);
            this.checkAccess(app);
        }
        if ((entity = this.timelineDataManager.getEntity("YARN_APPLICATION_ATTEMPT", appAttemptId.toString(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser())) == null) {
            throw new ApplicationAttemptNotFoundException("The entity for application attempt " + appAttemptId + " doesn't exist in the timeline store");
        }
        return ApplicationHistoryManagerOnTimelineStore.convertToApplicationAttemptReport(entity);
    }

    @Override
    public ContainerReport getContainer(ContainerId containerId) throws YarnException, IOException {
        ApplicationReportExt app = this.getApplication(containerId.getApplicationAttemptId().getApplicationId(), ApplicationReportField.USER_AND_ACLS);
        this.checkAccess(app);
        TimelineEntity entity = this.timelineDataManager.getEntity("YARN_CONTAINER", containerId.toString(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        if (entity == null) {
            throw new ContainerNotFoundException("The entity for container " + containerId + " doesn't exist in the timeline store");
        }
        return ApplicationHistoryManagerOnTimelineStore.convertToContainerReport(entity, this.serverHttpAddress, app.appReport.getUser());
    }

    @Override
    public ContainerReport getAMContainer(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        ApplicationAttemptReport appAttempt = this.getApplicationAttempt(appAttemptId, false);
        return this.getContainer(appAttempt.getAMContainerId());
    }

    @Override
    public Map<ContainerId, ContainerReport> getContainers(ApplicationAttemptId appAttemptId) throws YarnException, IOException {
        ApplicationReportExt app = this.getApplication(appAttemptId.getApplicationId(), ApplicationReportField.USER_AND_ACLS);
        this.checkAccess(app);
        TimelineEntities entities = this.timelineDataManager.getEntities("YARN_CONTAINER", new NameValuePair("YARN_CONTAINER_PARENT", appAttemptId.toString()), null, null, null, null, null, Long.MAX_VALUE, EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        LinkedHashMap<ContainerId, ContainerReport> containers = new LinkedHashMap<ContainerId, ContainerReport>();
        if (entities != null && entities.getEntities() != null) {
            for (TimelineEntity entity : entities.getEntities()) {
                ContainerReport container = ApplicationHistoryManagerOnTimelineStore.convertToContainerReport(entity, this.serverHttpAddress, app.appReport.getUser());
                containers.put(container.getContainerId(), container);
            }
        }
        return containers;
    }

    private static ApplicationReportExt convertToApplicationReport(TimelineEntity entity, ApplicationReportField field) {
        String user = null;
        String queue = null;
        String name = null;
        String type = null;
        boolean unmanagedApplication = false;
        long createdTime = 0L;
        long launchTime = 0L;
        long submittedTime = 0L;
        long finishedTime = 0L;
        float progress = 0.0f;
        int applicationPriority = 0;
        ApplicationAttemptId latestApplicationAttemptId = null;
        String diagnosticsInfo = null;
        FinalApplicationStatus finalStatus = FinalApplicationStatus.UNDEFINED;
        YarnApplicationState state = YarnApplicationState.ACCEPTED;
        ApplicationResourceUsageReport appResources = null;
        HashSet<String> appTags = null;
        HashMap<ApplicationAccessType, String> appViewACLs = new HashMap<ApplicationAccessType, String>();
        String appNodeLabelExpression = null;
        String amNodeLabelExpression = null;
        Map entityInfo = entity.getOtherInfo();
        if (entityInfo != null) {
            String appViewACLsStr;
            if (entityInfo.containsKey("YARN_APPLICATION_USER")) {
                user = entityInfo.get("YARN_APPLICATION_USER").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_VIEW_ACLS") && (appViewACLsStr = entityInfo.get("YARN_APPLICATION_VIEW_ACLS").toString()).length() > 0) {
                appViewACLs.put(ApplicationAccessType.VIEW_APP, appViewACLsStr);
            }
            if (field == ApplicationReportField.USER_AND_ACLS) {
                return new ApplicationReportExt(ApplicationReport.newInstance((ApplicationId)ApplicationId.fromString((String)entity.getEntityId()), latestApplicationAttemptId, (String)user, (String)queue, (String)name, null, (int)-1, null, (YarnApplicationState)state, diagnosticsInfo, null, (long)createdTime, (long)submittedTime, (long)0L, (long)finishedTime, (FinalApplicationStatus)finalStatus, null, null, (float)progress, (String)type, null, appTags, (boolean)unmanagedApplication, (Priority)Priority.newInstance((int)applicationPriority), appNodeLabelExpression, amNodeLabelExpression), appViewACLs);
            }
            if (entityInfo.containsKey("YARN_APPLICATION_QUEUE")) {
                queue = entityInfo.get("YARN_APPLICATION_QUEUE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_NAME")) {
                name = entityInfo.get("YARN_APPLICATION_NAME").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_TYPE")) {
                type = entityInfo.get("YARN_APPLICATION_TYPE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_TYPE")) {
                type = entityInfo.get("YARN_APPLICATION_TYPE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_UNMANAGED_APPLICATION")) {
                unmanagedApplication = Boolean.parseBoolean(entityInfo.get("YARN_APPLICATION_UNMANAGED_APPLICATION").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_PRIORITY")) {
                applicationPriority = Integer.parseInt(entityInfo.get("YARN_APPLICATION_PRIORITY").toString());
            }
            if (entityInfo.containsKey("YARN_APP_NODE_LABEL_EXPRESSION")) {
                appNodeLabelExpression = entityInfo.get("YARN_APP_NODE_LABEL_EXPRESSION").toString();
            }
            if (entityInfo.containsKey("YARN_AM_NODE_LABEL_EXPRESSION")) {
                amNodeLabelExpression = entityInfo.get("YARN_AM_NODE_LABEL_EXPRESSION").toString();
            }
            submittedTime = ApplicationHistoryManagerOnTimelineStore.parseLong(entityInfo, "YARN_APPLICATION_SUBMITTED_TIME");
            if (entityInfo.containsKey("YARN_APPLICATION_CPU")) {
                long vcoreSeconds = ApplicationHistoryManagerOnTimelineStore.parseLong(entityInfo, "YARN_APPLICATION_CPU");
                long memorySeconds = ApplicationHistoryManagerOnTimelineStore.parseLong(entityInfo, "YARN_APPLICATION_MEMORY");
                long preemptedMemorySeconds = ApplicationHistoryManagerOnTimelineStore.parseLong(entityInfo, "YARN_APPLICATION_MEM_PREEMPT_METRIC");
                long preemptedVcoreSeconds = ApplicationHistoryManagerOnTimelineStore.parseLong(entityInfo, "YARN_APPLICATION_CPU_PREEMPT_METRIC");
                HashMap<String, Long> resourceSecondsMap = new HashMap<String, Long>();
                HashMap<String, Long> preemptedResoureSecondsMap = new HashMap<String, Long>();
                resourceSecondsMap.put(ResourceInformation.MEMORY_MB.getName(), memorySeconds);
                resourceSecondsMap.put(ResourceInformation.VCORES.getName(), vcoreSeconds);
                preemptedResoureSecondsMap.put(ResourceInformation.MEMORY_MB.getName(), preemptedMemorySeconds);
                preemptedResoureSecondsMap.put(ResourceInformation.VCORES.getName(), preemptedVcoreSeconds);
                appResources = ApplicationResourceUsageReport.newInstance((int)0, (int)0, null, null, null, resourceSecondsMap, (float)0.0f, (float)0.0f, preemptedResoureSecondsMap);
            }
            if (entityInfo.containsKey("YARN_APPLICATION_TAGS")) {
                appTags = new HashSet<String>();
                Object obj = entityInfo.get("YARN_APPLICATION_TAGS");
                if (obj != null && obj instanceof Collection) {
                    for (Object o : (Collection)obj) {
                        if (o == null) continue;
                        appTags.add(o.toString());
                    }
                }
            }
        }
        List events = entity.getEvents();
        long updatedTimeStamp = 0L;
        if (events != null) {
            for (TimelineEvent event : events) {
                Map eventInfo;
                if (event.getEventType().equals("YARN_APPLICATION_CREATED")) {
                    createdTime = event.getTimestamp();
                    continue;
                }
                if (event.getEventType().equals("YARN_APPLICATION_LAUNCHED")) {
                    launchTime = event.getTimestamp();
                    continue;
                }
                if (event.getEventType().equals("YARN_APPLICATION_UPDATED")) {
                    if (event.getTimestamp() <= updatedTimeStamp) continue;
                    updatedTimeStamp = event.getTimestamp();
                    eventInfo = event.getEventInfo();
                    if (eventInfo == null) continue;
                    applicationPriority = Integer.parseInt(eventInfo.get("YARN_APPLICATION_PRIORITY").toString());
                    queue = eventInfo.get("YARN_APPLICATION_QUEUE").toString();
                    continue;
                }
                if (event.getEventType().equals("YARN_APPLICATION_STATE_UPDATED")) {
                    eventInfo = event.getEventInfo();
                    if (eventInfo == null || !eventInfo.containsKey("YARN_APPLICATION_STATE") || Apps.isApplicationFinalState((YarnApplicationState)state)) continue;
                    state = YarnApplicationState.valueOf((String)eventInfo.get("YARN_APPLICATION_STATE").toString());
                    continue;
                }
                if (!event.getEventType().equals("YARN_APPLICATION_FINISHED")) continue;
                progress = 1.0f;
                finishedTime = event.getTimestamp();
                eventInfo = event.getEventInfo();
                if (eventInfo == null) continue;
                if (eventInfo.containsKey("YARN_APPLICATION_LATEST_APP_ATTEMPT")) {
                    latestApplicationAttemptId = ApplicationAttemptId.fromString((String)eventInfo.get("YARN_APPLICATION_LATEST_APP_ATTEMPT").toString());
                }
                if (eventInfo.containsKey("YARN_APPLICATION_DIAGNOSTICS_INFO")) {
                    diagnosticsInfo = eventInfo.get("YARN_APPLICATION_DIAGNOSTICS_INFO").toString();
                }
                if (eventInfo.containsKey("YARN_APPLICATION_FINAL_STATUS")) {
                    finalStatus = FinalApplicationStatus.valueOf((String)eventInfo.get("YARN_APPLICATION_FINAL_STATUS").toString());
                }
                if (!eventInfo.containsKey("YARN_APPLICATION_STATE")) continue;
                state = YarnApplicationState.valueOf((String)eventInfo.get("YARN_APPLICATION_STATE").toString());
            }
        }
        return new ApplicationReportExt(ApplicationReport.newInstance((ApplicationId)ApplicationId.fromString((String)entity.getEntityId()), latestApplicationAttemptId, (String)user, (String)queue, (String)name, null, (int)-1, null, (YarnApplicationState)state, diagnosticsInfo, null, (long)createdTime, (long)submittedTime, (long)launchTime, (long)finishedTime, (FinalApplicationStatus)finalStatus, appResources, null, (float)progress, (String)type, null, appTags, (boolean)unmanagedApplication, (Priority)Priority.newInstance((int)applicationPriority), appNodeLabelExpression, amNodeLabelExpression), appViewACLs);
    }

    private static long parseLong(Map<String, Object> entityInfo, String infoKey) {
        long result = 0L;
        Object infoValue = entityInfo.get(infoKey);
        if (infoValue != null) {
            result = Long.parseLong(infoValue.toString());
        }
        return result;
    }

    private static ApplicationAttemptReport convertToApplicationAttemptReport(TimelineEntity entity) {
        String host = null;
        int rpcPort = -1;
        ContainerId amContainerId = null;
        String trackingUrl = null;
        String originalTrackingUrl = null;
        String diagnosticsInfo = null;
        YarnApplicationAttemptState state = null;
        List events = entity.getEvents();
        if (events != null) {
            for (TimelineEvent event : events) {
                Map eventInfo;
                if (event.getEventType().equals("YARN_APPLICATION_ATTEMPT_REGISTERED")) {
                    eventInfo = event.getEventInfo();
                    if (eventInfo == null) continue;
                    if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_HOST")) {
                        host = eventInfo.get("YARN_APPLICATION_ATTEMPT_HOST").toString();
                    }
                    if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_RPC_PORT")) {
                        rpcPort = (Integer)eventInfo.get("YARN_APPLICATION_ATTEMPT_RPC_PORT");
                    }
                    if (!eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER")) continue;
                    amContainerId = ContainerId.fromString((String)eventInfo.get("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER").toString());
                    continue;
                }
                if (!event.getEventType().equals("YARN_APPLICATION_ATTEMPT_FINISHED") || (eventInfo = event.getEventInfo()) == null) continue;
                if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_TRACKING_URL")) {
                    trackingUrl = eventInfo.get("YARN_APPLICATION_ATTEMPT_TRACKING_URL").toString();
                }
                if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL")) {
                    originalTrackingUrl = eventInfo.get("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL").toString();
                }
                if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO")) {
                    diagnosticsInfo = eventInfo.get("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO").toString();
                }
                if (eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_STATE")) {
                    state = YarnApplicationAttemptState.valueOf((String)eventInfo.get("YARN_APPLICATION_ATTEMPT_STATE").toString());
                }
                if (!eventInfo.containsKey("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER")) continue;
                amContainerId = ContainerId.fromString((String)eventInfo.get("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER").toString());
            }
        }
        return ApplicationAttemptReport.newInstance((ApplicationAttemptId)ApplicationAttemptId.fromString((String)entity.getEntityId()), host, (int)rpcPort, trackingUrl, originalTrackingUrl, diagnosticsInfo, state, amContainerId);
    }

    private static ContainerReport convertToContainerReport(TimelineEntity entity, String serverHttpAddress, String user) {
        List events;
        int allocatedMem = 0;
        int allocatedVcore = 0;
        String allocatedHost = null;
        int allocatedPort = -1;
        int allocatedPriority = 0;
        long createdTime = 0L;
        long finishedTime = 0L;
        String diagnosticsInfo = null;
        int exitStatus = -1000;
        ContainerState state = null;
        String nodeHttpAddress = null;
        Map exposedPorts = null;
        Map entityInfo = entity.getOtherInfo();
        if (entityInfo != null) {
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_MEMORY")) {
                allocatedMem = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_MEMORY");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_VCORE")) {
                allocatedVcore = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_VCORE");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_HOST")) {
                allocatedHost = entityInfo.get("YARN_CONTAINER_ALLOCATED_HOST").toString();
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_PORT")) {
                allocatedPort = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_PORT");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_PRIORITY")) {
                allocatedPriority = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_PRIORITY");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS")) {
                nodeHttpAddress = (String)entityInfo.get("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_EXPOSED_PORTS")) {
                exposedPorts = (Map)entityInfo.get("YARN_CONTAINER_ALLOCATED_EXPOSED_PORTS");
            }
        }
        if ((events = entity.getEvents()) != null) {
            for (TimelineEvent event : events) {
                if (event.getEventType().equals("YARN_CONTAINER_CREATED")) {
                    createdTime = event.getTimestamp();
                    continue;
                }
                if (!event.getEventType().equals("YARN_CONTAINER_FINISHED")) continue;
                finishedTime = event.getTimestamp();
                Map eventInfo = event.getEventInfo();
                if (eventInfo == null) continue;
                if (eventInfo.containsKey("YARN_CONTAINER_DIAGNOSTICS_INFO")) {
                    diagnosticsInfo = eventInfo.get("YARN_CONTAINER_DIAGNOSTICS_INFO").toString();
                }
                if (eventInfo.containsKey("YARN_CONTAINER_EXIT_STATUS")) {
                    exitStatus = (Integer)eventInfo.get("YARN_CONTAINER_EXIT_STATUS");
                }
                if (!eventInfo.containsKey("YARN_CONTAINER_STATE")) continue;
                state = ContainerState.valueOf((String)eventInfo.get("YARN_CONTAINER_STATE").toString());
            }
        }
        ContainerId containerId = ContainerId.fromString((String)entity.getEntityId());
        String logUrl = null;
        NodeId allocatedNode = null;
        if (allocatedHost != null) {
            allocatedNode = NodeId.newInstance((String)allocatedHost, (int)allocatedPort);
            logUrl = WebAppUtils.getAggregatedLogURL((String)serverHttpAddress, (String)allocatedNode.toString(), (String)containerId.toString(), (String)containerId.toString(), (String)user);
        }
        ContainerReport container = ContainerReport.newInstance((ContainerId)ContainerId.fromString((String)entity.getEntityId()), (Resource)Resource.newInstance((int)allocatedMem, (int)allocatedVcore), (NodeId)allocatedNode, (Priority)Priority.newInstance((int)allocatedPriority), (long)createdTime, (long)finishedTime, diagnosticsInfo, (String)logUrl, (int)exitStatus, state, (String)nodeHttpAddress);
        container.setExposedPorts(exposedPorts);
        return container;
    }

    private ApplicationReportExt generateApplicationReport(TimelineEntity entity, ApplicationReportField field) throws YarnException, IOException {
        ApplicationReportExt app = ApplicationHistoryManagerOnTimelineStore.convertToApplicationReport(entity, field);
        if (field == ApplicationReportField.USER_AND_ACLS) {
            return app;
        }
        try {
            this.checkAccess(app);
            if (app.appReport.getCurrentApplicationAttemptId() != null) {
                ApplicationAttemptReport appAttempt = this.getApplicationAttempt(app.appReport.getCurrentApplicationAttemptId(), false);
                app.appReport.setHost(appAttempt.getHost());
                app.appReport.setRpcPort(appAttempt.getRpcPort());
                app.appReport.setTrackingUrl(appAttempt.getTrackingUrl());
                app.appReport.setOriginalTrackingUrl(appAttempt.getOriginalTrackingUrl());
            }
        }
        catch (AuthorizationException | ApplicationAttemptNotFoundException e) {
            if (e instanceof AuthorizationException) {
                LOG.warn("Failed to authorize when generating application report for " + app.appReport.getApplicationId() + ". Use a placeholder for its latest attempt id. ", e);
            } else {
                LOG.info("No application attempt found for " + app.appReport.getApplicationId() + ". Use a placeholder for its latest attempt id. ", e);
            }
            app.appReport.setDiagnostics(null);
            app.appReport.setCurrentApplicationAttemptId(null);
        }
        if (app.appReport.getCurrentApplicationAttemptId() == null) {
            app.appReport.setCurrentApplicationAttemptId(ApplicationAttemptId.newInstance((ApplicationId)app.appReport.getApplicationId(), (int)-1));
        }
        if (app.appReport.getHost() == null) {
            app.appReport.setHost(UNAVAILABLE);
        }
        if (app.appReport.getRpcPort() < 0) {
            app.appReport.setRpcPort(-1);
        }
        if (app.appReport.getTrackingUrl() == null) {
            app.appReport.setTrackingUrl(UNAVAILABLE);
        }
        if (app.appReport.getOriginalTrackingUrl() == null) {
            app.appReport.setOriginalTrackingUrl(UNAVAILABLE);
        }
        if (app.appReport.getDiagnostics() == null) {
            app.appReport.setDiagnostics("");
        }
        return app;
    }

    private ApplicationReportExt getApplication(ApplicationId appId, ApplicationReportField field) throws YarnException, IOException {
        TimelineEntity entity = this.timelineDataManager.getEntity("YARN_APPLICATION", appId.toString(), EnumSet.allOf(TimelineReader.Field.class), UserGroupInformation.getLoginUser());
        if (entity == null) {
            throw new ApplicationNotFoundException("The entity for application " + appId + " doesn't exist in the timeline store");
        }
        return this.generateApplicationReport(entity, field);
    }

    private void checkAccess(ApplicationReportExt app) throws YarnException, IOException {
        if (app.appViewACLs != null) {
            this.aclsManager.addApplication(app.appReport.getApplicationId(), app.appViewACLs);
            try {
                if (!this.aclsManager.checkAccess(UserGroupInformation.getCurrentUser(), ApplicationAccessType.VIEW_APP, app.appReport.getUser(), app.appReport.getApplicationId())) {
                    throw new AuthorizationException("User " + UserGroupInformation.getCurrentUser().getShortUserName() + " does not have privilege to see this application " + app.appReport.getApplicationId());
                }
            }
            finally {
                this.aclsManager.removeApplication(app.appReport.getApplicationId());
            }
        }
    }

    private static class ApplicationReportExt {
        private ApplicationReport appReport;
        private Map<ApplicationAccessType, String> appViewACLs;

        public ApplicationReportExt(ApplicationReport appReport, Map<ApplicationAccessType, String> appViewACLs) {
            this.appReport = appReport;
            this.appViewACLs = appViewACLs;
        }
    }

    private static enum ApplicationReportField {
        ALL,
        USER_AND_ACLS;

    }
}

