/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthScriptRunner;

public class NodeHealthCheckerService
extends CompositeService {
    private NodeHealthScriptRunner nodeHealthScriptRunner;
    private LocalDirsHandlerService dirsHandler = new LocalDirsHandlerService();
    static final String SEPARATOR = ";";

    public NodeHealthCheckerService() {
        super(NodeHealthCheckerService.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (NodeHealthScriptRunner.shouldRun(conf)) {
            this.nodeHealthScriptRunner = new NodeHealthScriptRunner();
            this.addService((Service)this.nodeHealthScriptRunner);
        }
        this.addService((Service)this.dirsHandler);
        super.serviceInit(conf);
    }

    String getHealthReport() {
        String scriptReport;
        String string = scriptReport = this.nodeHealthScriptRunner == null ? "" : this.nodeHealthScriptRunner.getHealthReport();
        if (scriptReport.equals("")) {
            return this.dirsHandler.getDisksHealthReport();
        }
        return scriptReport.concat(SEPARATOR + this.dirsHandler.getDisksHealthReport());
    }

    boolean isHealthy() {
        boolean scriptHealthStatus = this.nodeHealthScriptRunner == null ? true : this.nodeHealthScriptRunner.isHealthy();
        return scriptHealthStatus && this.dirsHandler.areDisksHealthy();
    }

    long getLastHealthReportTime() {
        long diskCheckTime = this.dirsHandler.getLastDisksCheckTime();
        long lastReportTime = this.nodeHealthScriptRunner == null ? diskCheckTime : Math.max(this.nodeHealthScriptRunner.getLastReportedTime(), diskCheckTime);
        return lastReportTime;
    }

    public LocalDirsHandlerService getDiskHandler() {
        return this.dirsHandler;
    }

    NodeHealthScriptRunner getNodeHealthScriptRunner() {
        return this.nodeHealthScriptRunner;
    }
}

