/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.container;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryContext;
import org.apache.hadoop.yarn.api.records.ContainerRetryPolicy;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerSubState;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.NMAuditLogger;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerDiagnosticsUpdateEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerExitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerPauseEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerReInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerResourceFailedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerResourceLocalizedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerResumeEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.UpdateContainerTokenEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.LocalResourceRequest;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceSet;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationCleanupEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.ContainerLocalizationRequestEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.sharedcache.SharedCacheUploadEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.sharedcache.SharedCacheUploadEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerContainerFinishedEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainerStartMonitoringEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainerStopMonitoringEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ContainerSchedulerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.ContainerSchedulerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.scheduler.UpdateContainerSchedulerEvent;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.timelineservice.NMTimelinePublisher;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.state.StateTransitionListener;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerImpl
implements Container {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final Lock readLock;
    private final Lock writeLock;
    private final Dispatcher dispatcher;
    private final NMStateStoreService stateStore;
    private final Credentials credentials;
    private final NodeManagerMetrics metrics;
    private volatile ContainerLaunchContext launchContext;
    private volatile ContainerTokenIdentifier containerTokenIdentifier;
    private final ContainerId containerId;
    private final String user;
    private int version;
    private int exitCode = -1000;
    private final StringBuilder diagnostics;
    private final int diagnosticsMaxSize;
    private boolean wasLaunched;
    private long containerLocalizationStartTime;
    private long containerLaunchStartTime;
    private ContainerMetrics containerMetrics;
    private static Clock clock = SystemClock.getInstance();
    private ContainerRetryContext containerRetryContext;
    private int remainingRetryAttempts;
    private String workDir;
    private String logDir;
    private String host;
    private String ips;
    private volatile ReInitializationContext reInitContext;
    private volatile boolean isReInitializing = false;
    private volatile boolean isMarkeForKilling = false;
    private final Configuration daemonConf;
    private final long startTime;
    private static final Logger LOG = LoggerFactory.getLogger(ContainerImpl.class);
    private NMStateStoreService.RecoveredContainerStatus recoveredStatus = NMStateStoreService.RecoveredContainerStatus.REQUESTED;
    private boolean recoveredAsKilled = false;
    private Context context;
    private ResourceSet resourceSet;
    private static final ContainerDiagnosticsUpdateTransition UPDATE_DIAGNOSTICS_TRANSITION = new ContainerDiagnosticsUpdateTransition();
    private static StateMachineFactory<ContainerImpl, ContainerState, ContainerEventType, ContainerEvent> stateMachineFactory = new StateMachineFactory((Enum)ContainerState.NEW).addTransition((Enum)ContainerState.NEW, EnumSet.of(ContainerState.LOCALIZING, ContainerState.SCHEDULED, ContainerState.LOCALIZATION_FAILED, ContainerState.DONE), (Enum)ContainerEventType.INIT_CONTAINER, (MultipleArcTransition)new RequestResourcesTransition()).addTransition((Enum)ContainerState.NEW, (Enum)ContainerState.NEW, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.NEW, (Enum)ContainerState.DONE, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillOnNewTransition()).addTransition((Enum)ContainerState.NEW, (Enum)ContainerState.NEW, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN, (SingleArcTransition)new UpdateTransition()).addTransition((Enum)ContainerState.LOCALIZING, EnumSet.of(ContainerState.LOCALIZING, ContainerState.SCHEDULED), (Enum)ContainerEventType.RESOURCE_LOCALIZED, (MultipleArcTransition)new LocalizedTransition()).addTransition((Enum)ContainerState.LOCALIZING, (Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerEventType.RESOURCE_FAILED, (SingleArcTransition)new ResourceFailedTransition()).addTransition((Enum)ContainerState.LOCALIZING, (Enum)ContainerState.LOCALIZING, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.LOCALIZING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillBeforeRunningTransition()).addTransition((Enum)ContainerState.LOCALIZING, (Enum)ContainerState.LOCALIZING, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN, (SingleArcTransition)new UpdateTransition()).addTransition((Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerState.DONE, (Enum)ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition)new LocalizationFailedToDoneTransition()).addTransition((Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerState.LOCALIZATION_FAILED, EnumSet.of(ContainerEventType.KILL_CONTAINER, ContainerEventType.PAUSE_CONTAINER)).addTransition((Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerEventType.RESOURCE_LOCALIZED).addTransition((Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerEventType.RESOURCE_FAILED).addTransition((Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerState.LOCALIZATION_FAILED, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN, (SingleArcTransition)new UpdateTransition()).addTransition((Enum)ContainerState.SCHEDULED, (Enum)ContainerState.RUNNING, (Enum)ContainerEventType.CONTAINER_LAUNCHED, (SingleArcTransition)new LaunchTransition()).addTransition((Enum)ContainerState.SCHEDULED, (Enum)ContainerState.PAUSED, (Enum)ContainerEventType.RECOVER_PAUSED_CONTAINER, (SingleArcTransition)new RecoveredContainerTransition()).addTransition((Enum)ContainerState.SCHEDULED, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition)new ExitedWithFailureTransition(true)).addTransition((Enum)ContainerState.SCHEDULED, (Enum)ContainerState.SCHEDULED, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.SCHEDULED, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillBeforeRunningTransition()).addTransition((Enum)ContainerState.SCHEDULED, (Enum)ContainerState.SCHEDULED, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN, (SingleArcTransition)new NotifyContainerSchedulerOfUpdateTransition()).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, (SingleArcTransition)new ExitedWithSuccessTransition(true)).addTransition((Enum)ContainerState.RUNNING, EnumSet.of(ContainerState.RELAUNCHING, ContainerState.SCHEDULED, ContainerState.EXITED_WITH_FAILURE), (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (MultipleArcTransition)new RetryFailureTransition()).addTransition((Enum)ContainerState.RUNNING, EnumSet.of(ContainerState.RUNNING, ContainerState.REINITIALIZING, ContainerState.REINITIALIZING_AWAITING_KILL), (Enum)ContainerEventType.REINITIALIZE_CONTAINER, (MultipleArcTransition)new ReInitializeContainerTransition()).addTransition((Enum)ContainerState.RUNNING, EnumSet.of(ContainerState.RUNNING, ContainerState.REINITIALIZING, ContainerState.REINITIALIZING_AWAITING_KILL), (Enum)ContainerEventType.ROLLBACK_REINIT, (MultipleArcTransition)new RollbackContainerTransition()).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.RUNNING, (Enum)ContainerEventType.RESOURCE_LOCALIZED, (SingleArcTransition)new ResourceLocalizedWhileRunningTransition()).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.RUNNING, (Enum)ContainerEventType.RESOURCE_FAILED, (SingleArcTransition)new ResourceLocalizationFailedWhileRunningTransition()).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.RUNNING, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillTransition()).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_KILLED_ON_REQUEST, (SingleArcTransition)new KilledExternallyTransition()).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.PAUSING, (Enum)ContainerEventType.PAUSE_CONTAINER, (SingleArcTransition)new PauseContainerTransition()).addTransition((Enum)ContainerState.RUNNING, (Enum)ContainerState.RUNNING, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN, (SingleArcTransition)new NotifyContainerSchedulerOfUpdateTransition()).addTransition((Enum)ContainerState.PAUSING, (Enum)ContainerState.PAUSING, (Enum)ContainerEventType.RESOURCE_LOCALIZED, (SingleArcTransition)new ResourceLocalizedWhileRunningTransition()).addTransition((Enum)ContainerState.PAUSING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillTransition()).addTransition((Enum)ContainerState.PAUSING, (Enum)ContainerState.PAUSING, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.PAUSING, (Enum)ContainerState.PAUSED, (Enum)ContainerEventType.CONTAINER_PAUSED, (SingleArcTransition)new PausedContainerTransition()).addTransition((Enum)ContainerState.PAUSING, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS).addTransition((Enum)ContainerState.PAUSING, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition)new ExitedWithFailureTransition(true)).addTransition((Enum)ContainerState.PAUSING, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_KILLED_ON_REQUEST, (SingleArcTransition)new KilledExternallyTransition()).addTransition((Enum)ContainerState.PAUSING, (Enum)ContainerState.PAUSING, (Enum)ContainerEventType.RESOURCE_LOCALIZED, (SingleArcTransition)new ResourceLocalizedWhileRunningTransition()).addTransition((Enum)ContainerState.PAUSING, (Enum)ContainerState.PAUSING, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN, (SingleArcTransition)new NotifyContainerSchedulerOfUpdateTransition()).addTransition((Enum)ContainerState.PAUSED, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillTransition()).addTransition((Enum)ContainerState.PAUSED, (Enum)ContainerState.PAUSED, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.PAUSED, (Enum)ContainerState.PAUSED, (Enum)ContainerEventType.PAUSE_CONTAINER).addTransition((Enum)ContainerState.PAUSED, (Enum)ContainerState.PAUSED, (Enum)ContainerEventType.RESOURCE_LOCALIZED, (SingleArcTransition)new ResourceLocalizedWhileRunningTransition()).addTransition((Enum)ContainerState.PAUSED, (Enum)ContainerState.RESUMING, (Enum)ContainerEventType.RESUME_CONTAINER, (SingleArcTransition)new ResumeContainerTransition()).addTransition((Enum)ContainerState.PAUSED, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition)new ExitedWithFailureTransition(true)).addTransition((Enum)ContainerState.PAUSED, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_KILLED_ON_REQUEST, (SingleArcTransition)new KilledExternallyTransition()).addTransition((Enum)ContainerState.PAUSED, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, (SingleArcTransition)new ExitedWithSuccessTransition(true)).addTransition((Enum)ContainerState.PAUSED, (Enum)ContainerState.PAUSED, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN, (SingleArcTransition)new NotifyContainerSchedulerOfUpdateTransition()).addTransition((Enum)ContainerState.RESUMING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillTransition()).addTransition((Enum)ContainerState.RESUMING, (Enum)ContainerState.RUNNING, (Enum)ContainerEventType.CONTAINER_RESUMED).addTransition((Enum)ContainerState.RESUMING, (Enum)ContainerState.RESUMING, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.RESUMING, (Enum)ContainerState.RESUMING, (Enum)ContainerEventType.RESOURCE_LOCALIZED, (SingleArcTransition)new ResourceLocalizedWhileRunningTransition()).addTransition((Enum)ContainerState.RESUMING, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition)new ExitedWithFailureTransition(true)).addTransition((Enum)ContainerState.RESUMING, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_KILLED_ON_REQUEST, (SingleArcTransition)new KilledExternallyTransition()).addTransition((Enum)ContainerState.RESUMING, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, (SingleArcTransition)new ExitedWithSuccessTransition(true)).addTransition((Enum)ContainerState.RESUMING, (Enum)ContainerState.RESUMING, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN, (SingleArcTransition)new NotifyContainerSchedulerOfUpdateTransition()).addTransition((Enum)ContainerState.REINITIALIZING, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, (SingleArcTransition)new ExitedWithSuccessTransition(true)).addTransition((Enum)ContainerState.REINITIALIZING, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition)new ExitedWithFailureTransition(true)).addTransition((Enum)ContainerState.REINITIALIZING, EnumSet.of(ContainerState.REINITIALIZING, ContainerState.REINITIALIZING_AWAITING_KILL), (Enum)ContainerEventType.RESOURCE_LOCALIZED, (MultipleArcTransition)new ResourceLocalizedWhileReInitTransition()).addTransition((Enum)ContainerState.REINITIALIZING, (Enum)ContainerState.RUNNING, (Enum)ContainerEventType.RESOURCE_FAILED, (SingleArcTransition)new ResourceLocalizationFailedWhileReInitTransition()).addTransition((Enum)ContainerState.REINITIALIZING, (Enum)ContainerState.REINITIALIZING, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.REINITIALIZING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillTransition()).addTransition((Enum)ContainerState.REINITIALIZING, (Enum)ContainerState.PAUSING, (Enum)ContainerEventType.PAUSE_CONTAINER, (SingleArcTransition)new PauseContainerTransition()).addTransition((Enum)ContainerState.REINITIALIZING, (Enum)ContainerState.REINITIALIZING, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN, (SingleArcTransition)new NotifyContainerSchedulerOfUpdateTransition()).addTransition((Enum)ContainerState.REINITIALIZING_AWAITING_KILL, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, (SingleArcTransition)new ExitedWithSuccessTransition(true)).addTransition((Enum)ContainerState.REINITIALIZING_AWAITING_KILL, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition)new ExitedWithFailureTransition(true)).addTransition((Enum)ContainerState.REINITIALIZING_AWAITING_KILL, (Enum)ContainerState.REINITIALIZING_AWAITING_KILL, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.REINITIALIZING_AWAITING_KILL, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillTransition()).addTransition((Enum)ContainerState.REINITIALIZING_AWAITING_KILL, (Enum)ContainerState.SCHEDULED, (Enum)ContainerEventType.PAUSE_CONTAINER).addTransition((Enum)ContainerState.REINITIALIZING_AWAITING_KILL, (Enum)ContainerState.SCHEDULED, (Enum)ContainerEventType.CONTAINER_KILLED_ON_REQUEST, (SingleArcTransition)new KilledForReInitializationTransition()).addTransition((Enum)ContainerState.REINITIALIZING_AWAITING_KILL, (Enum)ContainerState.REINITIALIZING_AWAITING_KILL, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN, (SingleArcTransition)new NotifyContainerSchedulerOfUpdateTransition()).addTransition((Enum)ContainerState.RELAUNCHING, (Enum)ContainerState.RUNNING, (Enum)ContainerEventType.CONTAINER_LAUNCHED, (SingleArcTransition)new LaunchTransition()).addTransition((Enum)ContainerState.RELAUNCHING, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition)new ExitedWithFailureTransition(true)).addTransition((Enum)ContainerState.RELAUNCHING, (Enum)ContainerState.RELAUNCHING, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.RELAUNCHING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER, (SingleArcTransition)new KillTransition()).addTransition((Enum)ContainerState.RELAUNCHING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.PAUSE_CONTAINER, (SingleArcTransition)new KillOnPauseTransition()).addTransition((Enum)ContainerState.RELAUNCHING, (Enum)ContainerState.RELAUNCHING, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN, (SingleArcTransition)new NotifyContainerSchedulerOfUpdateTransition()).addTransition((Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerState.DONE, (Enum)ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition)new ExitedWithSuccessToDoneTransition()).addTransition((Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerState.EXITED_WITH_SUCCESS, EnumSet.of(ContainerEventType.KILL_CONTAINER, ContainerEventType.PAUSE_CONTAINER)).addTransition((Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN).addTransition((Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerState.DONE, (Enum)ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition)new ExitedWithFailureToDoneTransition()).addTransition((Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerState.EXITED_WITH_FAILURE, EnumSet.of(ContainerEventType.KILL_CONTAINER, ContainerEventType.PAUSE_CONTAINER)).addTransition((Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerEventType.CONTAINER_KILLED_ON_REQUEST, (SingleArcTransition)new ContainerKilledTransition()).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.RESOURCE_LOCALIZED, (SingleArcTransition)new LocalizedResourceDuringKillTransition()).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.RESOURCE_FAILED).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.KILL_CONTAINER).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.EXITED_WITH_SUCCESS, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, (SingleArcTransition)new ExitedWithSuccessTransition(false)).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.EXITED_WITH_FAILURE, (Enum)ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, (SingleArcTransition)new ExitedWithFailureTransition(false)).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.DONE, (Enum)ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition)new KillingToDoneTransition()).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.KILLING, EnumSet.of(ContainerEventType.CONTAINER_LAUNCHED, ContainerEventType.PAUSE_CONTAINER)).addTransition((Enum)ContainerState.KILLING, (Enum)ContainerState.KILLING, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN).addTransition((Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerState.DONE, (Enum)ContainerEventType.CONTAINER_RESOURCES_CLEANEDUP, (SingleArcTransition)new ContainerCleanedupAfterKillToDoneTransition()).addTransition((Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, EnumSet.of(ContainerEventType.KILL_CONTAINER, ContainerEventType.RESOURCE_FAILED, ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE, ContainerEventType.PAUSE_CONTAINER)).addTransition((Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerState.CONTAINER_CLEANEDUP_AFTER_KILL, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN).addTransition((Enum)ContainerState.DONE, (Enum)ContainerState.DONE, EnumSet.of(ContainerEventType.KILL_CONTAINER, ContainerEventType.PAUSE_CONTAINER)).addTransition((Enum)ContainerState.DONE, (Enum)ContainerState.DONE, (Enum)ContainerEventType.INIT_CONTAINER).addTransition((Enum)ContainerState.DONE, (Enum)ContainerState.DONE, (Enum)ContainerEventType.UPDATE_DIAGNOSTICS_MSG, (SingleArcTransition)UPDATE_DIAGNOSTICS_TRANSITION).addTransition((Enum)ContainerState.DONE, (Enum)ContainerState.DONE, EnumSet.of(ContainerEventType.RESOURCE_FAILED, ContainerEventType.CONTAINER_EXITED_WITH_SUCCESS, ContainerEventType.CONTAINER_EXITED_WITH_FAILURE)).addTransition((Enum)ContainerState.DONE, (Enum)ContainerState.DONE, (Enum)ContainerEventType.UPDATE_CONTAINER_TOKEN).installTopology();
    private final StateMachine<ContainerState, ContainerEventType, ContainerEvent> stateMachine;

    public ContainerImpl(Configuration conf, Dispatcher dispatcher, ContainerLaunchContext launchContext, Credentials creds, NodeManagerMetrics metrics, ContainerTokenIdentifier containerTokenIdentifier, Context context) {
        this(conf, dispatcher, launchContext, creds, metrics, containerTokenIdentifier, context, SystemClock.getInstance().getTime());
    }

    public ContainerImpl(Configuration conf, Dispatcher dispatcher, ContainerLaunchContext launchContext, Credentials creds, NodeManagerMetrics metrics, ContainerTokenIdentifier containerTokenIdentifier, Context context, long startTs) {
        this.startTime = startTs;
        this.daemonConf = conf;
        this.dispatcher = dispatcher;
        this.stateStore = context.getNMStateStore();
        this.version = containerTokenIdentifier.getVersion();
        this.launchContext = launchContext;
        this.diagnosticsMaxSize = conf.getInt("yarn.nodemanager.container-diagnostics-maximum-size", 10000);
        this.containerTokenIdentifier = containerTokenIdentifier;
        this.containerId = containerTokenIdentifier.getContainerID();
        this.diagnostics = new StringBuilder();
        this.credentials = creds;
        this.metrics = metrics;
        this.user = containerTokenIdentifier.getApplicationSubmitter();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.context = context;
        boolean containerMetricsEnabled = conf.getBoolean("yarn.nodemanager.container-metrics.enable", true);
        if (containerMetricsEnabled) {
            long flushPeriod = conf.getLong("yarn.nodemanager.container-metrics.period-ms", -1L);
            long unregisterDelay = conf.getLong("yarn.nodemanager.container-metrics.unregister-delay-ms", 10000L);
            this.containerMetrics = ContainerMetrics.forContainer(this.containerId, flushPeriod, unregisterDelay);
            this.containerMetrics.recordStartTime(clock.getTime());
        }
        this.containerRetryContext = ContainerImpl.configureRetryContext(conf, launchContext, this.containerId);
        this.remainingRetryAttempts = this.containerRetryContext.getMaxRetries();
        this.stateMachine = stateMachineFactory.make((Object)this, (Enum)ContainerState.NEW, (StateTransitionListener)context.getContainerStateTransitionListener());
        this.context = context;
        this.resourceSet = new ResourceSet();
    }

    private static ContainerRetryContext configureRetryContext(Configuration conf, ContainerLaunchContext launchContext, ContainerId containerId) {
        ContainerRetryContext context = launchContext != null && launchContext.getContainerRetryContext() != null ? launchContext.getContainerRetryContext() : ContainerRetryContext.NEVER_RETRY_CONTEXT;
        int minimumRestartInterval = conf.getInt("yarn.nodemanager.container-retry-minimum-interval-ms", 1000);
        if (context.getRetryPolicy() != ContainerRetryPolicy.NEVER_RETRY && context.getRetryInterval() < minimumRestartInterval) {
            LOG.info("Set restart interval to minimum value " + minimumRestartInterval + "ms for container " + containerId);
            context.setRetryInterval(minimumRestartInterval);
        }
        return context;
    }

    public ContainerImpl(Configuration conf, Dispatcher dispatcher, ContainerLaunchContext launchContext, Credentials creds, NodeManagerMetrics metrics, ContainerTokenIdentifier containerTokenIdentifier, Context context, NMStateStoreService.RecoveredContainerState rcs) {
        this(conf, dispatcher, launchContext, creds, metrics, containerTokenIdentifier, context, rcs.getStartTime());
        this.recoveredStatus = rcs.getStatus();
        this.exitCode = rcs.getExitCode();
        this.recoveredAsKilled = rcs.getKilled();
        this.diagnostics.append(rcs.getDiagnostics());
        this.version = rcs.getVersion();
        this.remainingRetryAttempts = rcs.getRemainingRetryAttempts();
        this.workDir = rcs.getWorkDir();
        this.logDir = rcs.getLogDir();
    }

    public org.apache.hadoop.yarn.api.records.ContainerState getCurrentState() {
        switch ((ContainerState)this.stateMachine.getCurrentState()) {
            case NEW: 
            case LOCALIZING: 
            case LOCALIZATION_FAILED: 
            case SCHEDULED: 
            case PAUSED: 
            case RESUMING: 
            case RUNNING: 
            case RELAUNCHING: 
            case REINITIALIZING: 
            case REINITIALIZING_AWAITING_KILL: 
            case EXITED_WITH_SUCCESS: 
            case EXITED_WITH_FAILURE: 
            case KILLING: 
            case CONTAINER_CLEANEDUP_AFTER_KILL: 
            case CONTAINER_RESOURCES_CLEANINGUP: 
            case PAUSING: {
                return org.apache.hadoop.yarn.api.records.ContainerState.RUNNING;
            }
        }
        return org.apache.hadoop.yarn.api.records.ContainerState.COMPLETE;
    }

    private ContainerSubState getContainerSubState() {
        switch ((ContainerState)this.stateMachine.getCurrentState()) {
            case NEW: 
            case LOCALIZING: 
            case SCHEDULED: 
            case RELAUNCHING: 
            case REINITIALIZING_AWAITING_KILL: {
                return ContainerSubState.SCHEDULED;
            }
            case RUNNING: 
            case REINITIALIZING: 
            case KILLING: 
            case PAUSING: {
                return ContainerSubState.RUNNING;
            }
            case PAUSED: 
            case RESUMING: {
                return ContainerSubState.PAUSED;
            }
            case LOCALIZATION_FAILED: 
            case EXITED_WITH_SUCCESS: 
            case EXITED_WITH_FAILURE: 
            case CONTAINER_CLEANEDUP_AFTER_KILL: 
            case CONTAINER_RESOURCES_CLEANINGUP: {
                return ContainerSubState.COMPLETING;
            }
        }
        return ContainerSubState.DONE;
    }

    public NMTimelinePublisher getNMTimelinePublisher() {
        return this.context.getNMTimelinePublisher();
    }

    @Override
    public String getUser() {
        this.readLock.lock();
        try {
            String string = this.user;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<Path, List<String>> getLocalizedResources() {
        this.readLock.lock();
        try {
            if (ContainerState.SCHEDULED == this.getContainerState() || ContainerState.RELAUNCHING == this.getContainerState()) {
                Map<Path, List<String>> map = this.resourceSet.getLocalizedResources();
                return map;
            }
            Map<Path, List<String>> map = null;
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Credentials getCredentials() {
        this.readLock.lock();
        try {
            Credentials credentials = this.credentials;
            return credentials;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContainerState getContainerState() {
        this.readLock.lock();
        try {
            ContainerState containerState = (ContainerState)this.stateMachine.getCurrentState();
            return containerState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContainerLaunchContext getLaunchContext() {
        this.readLock.lock();
        try {
            ContainerLaunchContext containerLaunchContext = this.launchContext;
            return containerLaunchContext;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContainerStatus cloneAndGetContainerStatus() {
        this.readLock.lock();
        try {
            ContainerStatus status = BuilderUtils.newContainerStatus((ContainerId)this.containerId, (org.apache.hadoop.yarn.api.records.ContainerState)this.getCurrentState(), (String)this.diagnostics.toString(), (int)this.exitCode, (Resource)this.getResource(), (ExecutionType)this.containerTokenIdentifier.getExecutionType());
            status.setIPs(this.ips == null ? null : Arrays.asList(this.ips.split(",")));
            status.setHost(this.host);
            status.setContainerSubState(this.getContainerSubState());
            ContainerStatus containerStatus = status;
            return containerStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public NMContainerStatus getNMContainerStatus() {
        this.readLock.lock();
        try {
            NMContainerStatus nMContainerStatus = NMContainerStatus.newInstance((ContainerId)this.containerId, (int)this.version, (org.apache.hadoop.yarn.api.records.ContainerState)this.getCurrentState(), (Resource)this.getResource(), (String)this.diagnostics.toString(), (int)this.exitCode, (Priority)this.containerTokenIdentifier.getPriority(), (long)this.containerTokenIdentifier.getCreationTime(), (String)this.containerTokenIdentifier.getNodeLabelExpression(), (ExecutionType)this.containerTokenIdentifier.getExecutionType());
            return nMContainerStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ContainerId getContainerId() {
        return this.containerId;
    }

    @Override
    public long getContainerStartTime() {
        return this.startTime;
    }

    @Override
    public Resource getResource() {
        return Resources.clone((Resource)this.containerTokenIdentifier.getResource());
    }

    @Override
    public ContainerTokenIdentifier getContainerTokenIdentifier() {
        this.readLock.lock();
        try {
            ContainerTokenIdentifier containerTokenIdentifier = this.containerTokenIdentifier;
            return containerTokenIdentifier;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setContainerTokenIdentifier(ContainerTokenIdentifier token) {
        this.writeLock.lock();
        try {
            this.containerTokenIdentifier = token;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getWorkDir() {
        return this.workDir;
    }

    @Override
    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    @Override
    public void setIpAndHost(String[] ipAndHost) {
        this.ips = ipAndHost[0];
        this.host = ipAndHost[1];
    }

    @Override
    public String getLogDir() {
        return this.logDir;
    }

    @Override
    public void setLogDir(String logDir) {
        this.logDir = logDir;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    private void sendFinishedEvents() {
        EventHandler eventHandler = this.dispatcher.getEventHandler();
        ContainerStatus containerStatus = this.cloneAndGetContainerStatus();
        eventHandler.handle((Event)new ApplicationContainerFinishedEvent(containerStatus, this.startTime));
        eventHandler.handle((Event)new ContainerSchedulerEvent(this, ContainerSchedulerEventType.CONTAINER_COMPLETED));
        eventHandler.handle((Event)new ContainerStopMonitoringEvent(this.containerId));
        eventHandler.handle((Event)new LogHandlerContainerFinishedEvent(this.containerId, this.containerTokenIdentifier.getContainerType(), this.exitCode));
    }

    @Override
    public void sendLaunchEvent() {
        if (ContainerState.PAUSED == this.getContainerState()) {
            this.dispatcher.getEventHandler().handle((Event)new ContainerResumeEvent(this.containerId, "Container Resumed as some resources freed up"));
        } else {
            ContainersLauncherEventType launcherEvent = ContainersLauncherEventType.LAUNCH_CONTAINER;
            if (this.recoveredStatus == NMStateStoreService.RecoveredContainerStatus.LAUNCHED) {
                launcherEvent = ContainersLauncherEventType.RECOVER_CONTAINER;
            } else if (this.recoveredStatus == NMStateStoreService.RecoveredContainerStatus.PAUSED) {
                launcherEvent = ContainersLauncherEventType.RECOVER_PAUSED_CONTAINER;
            }
            this.containerLaunchStartTime = clock.getTime();
            this.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(this, launcherEvent));
        }
    }

    private void sendScheduleEvent() {
        if (this.recoveredStatus == NMStateStoreService.RecoveredContainerStatus.PAUSED) {
            ContainersLauncherEventType launcherEvent = ContainersLauncherEventType.RECOVER_PAUSED_CONTAINER;
            this.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(this, launcherEvent));
        } else {
            this.dispatcher.getEventHandler().handle((Event)new ContainerSchedulerEvent(this, ContainerSchedulerEventType.SCHEDULE_CONTAINER));
        }
    }

    @Override
    public void sendKillEvent(int exitStatus, String description) {
        this.isMarkeForKilling = true;
        this.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(this.containerId, exitStatus, description));
    }

    @Override
    public void sendPauseEvent(String description) {
        this.dispatcher.getEventHandler().handle((Event)new ContainerPauseEvent(this.containerId, description));
    }

    private void sendRelaunchEvent() {
        ContainersLauncherEventType launcherEvent = ContainersLauncherEventType.RELAUNCH_CONTAINER;
        this.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(this, launcherEvent));
    }

    private void sendContainerMonitorStartEvent() {
        long launchDuration = clock.getTime() - this.containerLaunchStartTime;
        this.metrics.addContainerLaunchDuration(launchDuration);
        long pmemBytes = this.getResource().getMemorySize() * 1024L * 1024L;
        float pmemRatio = this.daemonConf.getFloat("yarn.nodemanager.vmem-pmem-ratio", 2.1f);
        long vmemBytes = (long)(pmemRatio * (float)pmemBytes);
        int cpuVcores = this.getResource().getVirtualCores();
        long localizationDuration = this.containerLaunchStartTime - this.containerLocalizationStartTime;
        this.dispatcher.getEventHandler().handle((Event)new ContainerStartMonitoringEvent(this.containerId, vmemBytes, pmemBytes, cpuVcores, launchDuration, localizationDuration));
    }

    private void addDiagnostics(String ... diags) {
        for (String s : diags) {
            this.diagnostics.append("[" + this.dateFormat.format(new Date()) + "]" + s);
        }
        if (this.diagnostics.length() > this.diagnosticsMaxSize) {
            this.diagnostics.delete(0, this.diagnostics.length() - this.diagnosticsMaxSize);
        }
        try {
            this.stateStore.storeContainerDiagnostics(this.containerId, this.diagnostics);
        }
        catch (IOException e) {
            LOG.warn("Unable to update diagnostics in state store for " + this.containerId, (Throwable)e);
        }
    }

    public void cleanup() {
        Map<LocalResourceVisibility, Collection<LocalResourceRequest>> rsrc = this.resourceSet.getAllResourcesByVisibility();
        this.dispatcher.getEventHandler().handle((Event)new ContainerLocalizationCleanupEvent(this, rsrc));
    }

    @Override
    public boolean isRetryContextSet() {
        return this.containerRetryContext.getRetryPolicy() != ContainerRetryPolicy.NEVER_RETRY;
    }

    @Override
    public boolean shouldRetry(int errorCode) {
        return ContainerImpl.shouldRetry(errorCode, this.containerRetryContext, this.remainingRetryAttempts);
    }

    public static boolean shouldRetry(int errorCode, ContainerRetryContext retryContext, int remainingRetryAttempts) {
        if (errorCode == ContainerExecutor.ExitCode.SUCCESS.getExitCode() || errorCode == ContainerExecutor.ExitCode.FORCE_KILLED.getExitCode() || errorCode == ContainerExecutor.ExitCode.TERMINATED.getExitCode()) {
            return false;
        }
        ContainerRetryPolicy retryPolicy = retryContext.getRetryPolicy();
        if (retryPolicy == ContainerRetryPolicy.RETRY_ON_ALL_ERRORS || retryPolicy == ContainerRetryPolicy.RETRY_ON_SPECIFIC_ERROR_CODES && retryContext.getErrorCodes() != null && retryContext.getErrorCodes().contains(errorCode)) {
            return remainingRetryAttempts > 0 || remainingRetryAttempts == -1;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ContainerEvent event) {
        try {
            this.writeLock.lock();
            ContainerId containerID = event.getContainerID();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing " + containerID + " of type " + event.getType());
            }
            ContainerState oldState = (ContainerState)this.stateMachine.getCurrentState();
            ContainerState newState = null;
            try {
                newState = (ContainerState)this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.warn("Can't handle this event at current state: Current: [" + (Object)((Object)oldState) + "], eventType: [" + event.getType() + "], container: [" + containerID + "]", (Throwable)e);
            }
            if (newState != null && oldState != newState) {
                LOG.info("Container " + containerID + " transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)newState));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String toString() {
        this.readLock.lock();
        try {
            String string = this.containerId.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean hasDefaultExitCode() {
        return this.exitCode == -1000;
    }

    private static boolean shouldBeUploadedToSharedCache(ContainerImpl container, LocalResourceRequest resource) {
        return container.resourceSet.getResourcesUploadPolicies().get(resource);
    }

    @VisibleForTesting
    ContainerRetryContext getContainerRetryContext() {
        return this.containerRetryContext;
    }

    @Override
    public Priority getPriority() {
        return this.containerTokenIdentifier.getPriority();
    }

    @Override
    public boolean isRunning() {
        return this.getContainerState() == ContainerState.RUNNING;
    }

    @Override
    public void setIsReInitializing(boolean isReInitializing) {
        if (this.isReInitializing && !isReInitializing) {
            this.metrics.endReInitingContainer();
        }
        this.isReInitializing = isReInitializing;
    }

    @Override
    public boolean isReInitializing() {
        return this.isReInitializing;
    }

    @Override
    public boolean isMarkedForKilling() {
        return this.isMarkeForKilling;
    }

    @Override
    public boolean canRollback() {
        return this.reInitContext != null && this.reInitContext.canRollback();
    }

    @Override
    public void commitUpgrade() {
        this.reInitContext = null;
    }

    @Override
    public boolean isRecovering() {
        boolean isRecovering = this.recoveredStatus != NMStateStoreService.RecoveredContainerStatus.REQUESTED && this.getContainerState() == ContainerState.NEW;
        return isRecovering;
    }

    static class ResumeContainerTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ResumeContainerTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.RESUME_CONTAINER));
            ContainerResumeEvent resumeEvent = (ContainerResumeEvent)event;
            container.addDiagnostics(new String[]{resumeEvent.getDiagnostic() + "\n"});
        }
    }

    static class PausedContainerTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        PausedContainerTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            container.dispatcher.getEventHandler().handle((Event)new ContainerSchedulerEvent(container, ContainerSchedulerEventType.CONTAINER_PAUSED));
        }
    }

    static class PauseContainerTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        PauseContainerTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.PAUSE_CONTAINER));
            ContainerPauseEvent pauseEvent = (ContainerPauseEvent)event;
            container.addDiagnostics(new String[]{pauseEvent.getDiagnostic() + "\n"});
        }
    }

    static class ContainerDiagnosticsUpdateTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerDiagnosticsUpdateTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerDiagnosticsUpdateEvent updateEvent = (ContainerDiagnosticsUpdateEvent)event;
            container.addDiagnostics(new String[]{updateEvent.getDiagnosticsUpdate() + "\n"});
        }
    }

    static class ContainerCleanedupAfterKillToDoneTransition
    extends ContainerDoneTransition {
        ContainerCleanedupAfterKillToDoneTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            if (container.wasLaunched) {
                container.metrics.endRunningContainer();
            }
            container.metrics.killedContainer();
            NMAuditLogger.logSuccess(container.user, "Container Finished - Killed", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            super.transition(container, event);
        }
    }

    static class KillingToDoneTransition
    extends ContainerDoneTransition {
        KillingToDoneTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.metrics.killedContainer();
            NMAuditLogger.logSuccess(container.user, "Container Finished - Killed", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            super.transition(container, event);
        }
    }

    static class ExitedWithFailureToDoneTransition
    extends ContainerDoneTransition {
        ExitedWithFailureToDoneTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            if (container.wasLaunched) {
                container.metrics.endRunningContainer();
            }
            container.metrics.failedContainer();
            NMAuditLogger.logFailure(container.user, "Container Finished - Failed", "ContainerImpl", "Container failed with state: " + (Object)((Object)container.getContainerState()), container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            super.transition(container, event);
        }
    }

    static class ExitedWithSuccessToDoneTransition
    extends ContainerDoneTransition {
        ExitedWithSuccessToDoneTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            if (container.wasLaunched) {
                container.metrics.endRunningContainer();
            } else {
                LOG.warn("Container exited with success despite being killed and notactually running");
            }
            container.metrics.completedContainer();
            NMAuditLogger.logSuccess(container.user, "Container Finished - Succeeded", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            super.transition(container, event);
        }
    }

    static class LocalizationFailedToDoneTransition
    extends ContainerDoneTransition {
        LocalizationFailedToDoneTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.metrics.failedContainer();
            NMAuditLogger.logFailure(container.user, "Container Finished - Failed", "ContainerImpl", "Container failed with state: " + (Object)((Object)container.getContainerState()), container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            super.transition(container, event);
        }
    }

    static class KillOnNewTransition
    extends ContainerDoneTransition {
        KillOnNewTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            if (container.recoveredStatus == NMStateStoreService.RecoveredContainerStatus.COMPLETED) {
                container.sendFinishedEvents();
            } else {
                ContainerKillEvent killEvent = (ContainerKillEvent)event;
                container.exitCode = killEvent.getContainerExitStatus();
                container.addDiagnostics(new String[]{killEvent.getDiagnostic() + "\n"});
                container.addDiagnostics(new String[]{"Container is killed before being launched.\n"});
                container.metrics.killedContainer();
                NMAuditLogger.logSuccess(container.user, "Container Finished - Killed", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
                super.transition(container, event);
            }
        }
    }

    static class ContainerDoneTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerDoneTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            container.metrics.releaseContainer(container.containerTokenIdentifier.getResource());
            if (container.containerMetrics != null) {
                container.containerMetrics.recordFinishTimeAndExitCode(clock.getTime(), container.exitCode);
                container.containerMetrics.finished();
            }
            container.sendFinishedEvents();
            if (container.getCurrentState() != org.apache.hadoop.yarn.api.records.ContainerState.NEW) {
                container.dispatcher.getEventHandler().handle((Event)new AuxServicesEvent(AuxServicesEventType.CONTAINER_STOP, container));
            }
            container.context.getNodeStatusUpdater().sendOutofBandHeartBeat();
        }
    }

    static class ContainerKilledTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerKilledTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerExitEvent exitEvent = (ContainerExitEvent)event;
            if (container.hasDefaultExitCode()) {
                container.exitCode = exitEvent.getExitCode();
            }
            if (exitEvent.getDiagnosticInfo() != null) {
                container.addDiagnostics(new String[]{exitEvent.getDiagnosticInfo() + "\n"});
            }
            container.cleanup();
        }
    }

    static class KillOnPauseTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        KillOnPauseTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            container.setIsReInitializing(false);
            container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
        }
    }

    static class KillTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        KillTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            container.setIsReInitializing(false);
            container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
            ContainerKillEvent killEvent = (ContainerKillEvent)event;
            container.addDiagnostics(new String[]{killEvent.getDiagnostic() + "\n"});
            container.exitCode = killEvent.getContainerExitStatus();
        }
    }

    static class LocalizedResourceDuringKillTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        LocalizedResourceDuringKillTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceLocalizedEvent rsrcEvent = (ContainerResourceLocalizedEvent)event;
            container.resourceSet.resourceLocalized(rsrcEvent.getResource(), rsrcEvent.getLocation());
        }
    }

    static class KillBeforeRunningTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        KillBeforeRunningTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            container.cleanup();
            container.metrics.endInitingContainer();
            ContainerKillEvent killEvent = (ContainerKillEvent)event;
            container.exitCode = killEvent.getContainerExitStatus();
            container.addDiagnostics(new String[]{killEvent.getDiagnostic() + "\n"});
            container.addDiagnostics(new String[]{"Container is killed before being launched.\n"});
        }
    }

    static class ResourceFailedTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ResourceFailedTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceFailedEvent rsrcFailedEvent = (ContainerResourceFailedEvent)event;
            container.addDiagnostics(new String[]{rsrcFailedEvent.getDiagnosticMessage() + "\n"});
            container.cleanup();
            container.metrics.endInitingContainer();
        }
    }

    static class KilledForReInitializationTransition
    extends ContainerTransition {
        KilledForReInitializationTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            LOG.info("Relaunching Container [" + container.getContainerId() + "] for re-initialization !!");
            container.wasLaunched = false;
            container.metrics.endRunningContainer();
            container.launchContext = container.reInitContext.newLaunchContext;
            container.containerRetryContext = ContainerImpl.configureRetryContext(container.context.getConf(), container.launchContext, container.containerId);
            container.remainingRetryAttempts = container.containerRetryContext.getMaxRetries();
            container.resourceSet = container.reInitContext.mergedResourceSet(container.resourceSet);
            container.isMarkeForKilling = false;
            container.dispatcher.getEventHandler().handle((Event)new ContainerSchedulerEvent(container, ContainerSchedulerEventType.CONTAINER_COMPLETED));
            container.sendScheduleEvent();
        }
    }

    static class KilledExternallyTransition
    extends ExitedWithFailureTransition {
        KilledExternallyTransition() {
            super(true);
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            super.transition(container, event);
            container.addDiagnostics(new String[]{"Killed by external signal\n"});
        }
    }

    static class RetryFailureTransition
    implements MultipleArcTransition<ContainerImpl, ContainerEvent, ContainerState> {
        RetryFailureTransition() {
        }

        public ContainerState transition(ContainerImpl container, ContainerEvent event) {
            ContainerExitEvent exitEvent = (ContainerExitEvent)event;
            container.exitCode = exitEvent.getExitCode();
            if (exitEvent.getDiagnosticInfo() != null) {
                if (container.containerRetryContext.getRetryPolicy() != ContainerRetryPolicy.NEVER_RETRY) {
                    int n = container.containerRetryContext.getMaxRetries() - container.remainingRetryAttempts;
                    container.addDiagnostics(new String[]{"Diagnostic message from attempt " + n + " : ", "\n"});
                }
                container.addDiagnostics(new String[]{exitEvent.getDiagnosticInfo() + "\n"});
            }
            if (container.shouldRetry(container.exitCode)) {
                if (container.remainingRetryAttempts > 0) {
                    container.remainingRetryAttempts--;
                    try {
                        container.stateStore.storeContainerRemainingRetryAttempts(container.getContainerId(), container.remainingRetryAttempts);
                    }
                    catch (IOException e) {
                        LOG.warn("Unable to update remainingRetryAttempts in state store for " + container.getContainerId(), (Throwable)e);
                    }
                }
                this.doRelaunch(container, container.remainingRetryAttempts, container.containerRetryContext.getRetryInterval());
                return ContainerState.RELAUNCHING;
            }
            if (container.canRollback()) {
                container.addDiagnostics(new String[]{"Container Re-init Auto Rolled-Back."});
                LOG.info("Rolling back Container reInitialization for [" + container.getContainerId() + "] !!");
                container.reInitContext = container.reInitContext.createContextForRollback();
                container.metrics.rollbackContainerOnFailure();
                container.metrics.reInitingContainer();
                NMAuditLogger.logSuccess(container.user, "Container ReInitialization - Started", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
                new KilledForReInitializationTransition().transition(container, event);
                return ContainerState.SCHEDULED;
            }
            new ExitedWithFailureTransition(true).transition(container, event);
            return ContainerState.EXITED_WITH_FAILURE;
        }

        private void doRelaunch(final ContainerImpl container, int remainingRetryAttempts, final int retryInterval) {
            LOG.info("Relaunching Container " + container.getContainerId() + ". Remaining retry attempts(after relaunch) : " + remainingRetryAttempts + ". Interval between retries is " + retryInterval + "ms");
            container.wasLaunched = false;
            container.metrics.endRunningContainer();
            if (retryInterval == 0) {
                container.sendRelaunchEvent();
            } else {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(retryInterval);
                            container.sendRelaunchEvent();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }.start();
            }
        }
    }

    static class ExitedWithFailureTransition
    extends ContainerTransition {
        boolean clCleanupRequired;

        public ExitedWithFailureTransition(boolean clCleanupRequired) {
            this.clCleanupRequired = clCleanupRequired;
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.setIsReInitializing(false);
            ContainerExitEvent exitEvent = (ContainerExitEvent)event;
            container.exitCode = exitEvent.getExitCode();
            if (exitEvent.getDiagnosticInfo() != null) {
                container.addDiagnostics(new String[]{exitEvent.getDiagnosticInfo() + "\n"});
            }
            if (this.clCleanupRequired) {
                container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
            }
            container.cleanup();
        }
    }

    static class ExitedWithSuccessTransition
    extends ContainerTransition {
        boolean clCleanupRequired;

        public ExitedWithSuccessTransition(boolean clCleanupRequired) {
            this.clCleanupRequired = clCleanupRequired;
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.setIsReInitializing(false);
            container.exitCode = 0;
            if (this.clCleanupRequired) {
                container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
            }
            container.cleanup();
        }
    }

    static class RecoveredContainerTransition
    extends ContainerTransition {
        RecoveredContainerTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.sendContainerMonitorStartEvent();
            container.wasLaunched = true;
        }
    }

    static class LaunchTransition
    extends ContainerTransition {
        LaunchTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            container.sendContainerMonitorStartEvent();
            container.metrics.runningContainer();
            container.wasLaunched = true;
            if (container.isReInitializing()) {
                NMAuditLogger.logSuccess(container.user, "Container ReInitialization - Finished", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            }
            container.setIsReInitializing(false);
            if (container.reInitContext != null && !container.reInitContext.canRollback()) {
                container.reInitContext = null;
            }
            if (container.recoveredAsKilled) {
                LOG.info("Killing " + container.containerId + " due to recovered as killed");
                container.addDiagnostics(new String[]{"Container recovered as killed.\n"});
                container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER));
            }
        }
    }

    static class ResourceLocalizationFailedWhileReInitTransition
    extends ContainerTransition {
        ResourceLocalizationFailedWhileReInitTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceFailedEvent failedEvent = (ContainerResourceFailedEvent)event;
            container.resourceSet.resourceLocalizationFailed(failedEvent.getResource());
            container.addDiagnostics(new String[]{"Container aborting re-initialization.. " + failedEvent.getDiagnosticMessage()});
            LOG.error("Container [" + container.getContainerId() + "] Re-init failed !! Resource [" + failedEvent.getResource() + "] could not be localized !!");
            container.reInitContext = null;
        }
    }

    static class ResourceLocalizationFailedWhileRunningTransition
    extends ContainerTransition {
        ResourceLocalizationFailedWhileRunningTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceFailedEvent failedEvent = (ContainerResourceFailedEvent)event;
            container.resourceSet.resourceLocalizationFailed(failedEvent.getResource());
            container.addDiagnostics(new String[]{failedEvent.getDiagnosticMessage()});
        }
    }

    static class ResourceLocalizedWhileRunningTransition
    extends ContainerTransition {
        ResourceLocalizedWhileRunningTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceLocalizedEvent rsrcEvent = (ContainerResourceLocalizedEvent)event;
            Set<String> links = container.resourceSet.resourceLocalized(rsrcEvent.getResource(), rsrcEvent.getLocation());
            if (links == null) {
                return;
            }
            for (String link : links) {
                try {
                    String linkFile = new Path(container.workDir, link).toString();
                    if (new File(linkFile).exists()) {
                        LOG.info("Symlink file already exists: " + linkFile);
                        continue;
                    }
                    container.context.getContainerExecutor().symLink(rsrcEvent.getLocation().toString(), linkFile);
                    LOG.info("Created symlink: " + linkFile + " -> " + rsrcEvent.getLocation());
                }
                catch (IOException e) {
                    String message = String.format("Error when creating symlink %s -> %s", link, rsrcEvent.getLocation());
                    LOG.error(message, (Throwable)e);
                }
            }
        }
    }

    static class ResourceLocalizedWhileReInitTransition
    implements MultipleArcTransition<ContainerImpl, ContainerEvent, ContainerState> {
        ResourceLocalizedWhileReInitTransition() {
        }

        public ContainerState transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceLocalizedEvent rsrcEvent = (ContainerResourceLocalizedEvent)event;
            container.reInitContext.newResourceSet.resourceLocalized(rsrcEvent.getResource(), rsrcEvent.getLocation());
            if (container.reInitContext.newResourceSet.getPendingResources().isEmpty()) {
                container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER_FOR_REINIT));
                return ContainerState.REINITIALIZING_AWAITING_KILL;
            }
            return ContainerState.REINITIALIZING;
        }
    }

    static class RollbackContainerTransition
    extends ReInitializeContainerTransition {
        RollbackContainerTransition() {
        }

        @Override
        protected ReInitializationContext createReInitContext(ContainerImpl container, ContainerEvent event) {
            container.addDiagnostics(new String[]{"Container upgrade will be Rolled-back.\n"});
            LOG.warn("Container [" + container.getContainerId() + "] about to be explicitly Rolledback !!");
            return container.reInitContext.createContextForRollback();
        }
    }

    static class ReInitializeContainerTransition
    implements MultipleArcTransition<ContainerImpl, ContainerEvent, ContainerState> {
        ReInitializeContainerTransition() {
        }

        public ContainerState transition(ContainerImpl container, ContainerEvent event) {
            container.reInitContext = this.createReInitContext(container, event);
            boolean resourcesPresent = false;
            try {
                ResourceSet newResourceSet = container.reInitContext.newResourceSet;
                if (!newResourceSet.getPendingResources().isEmpty()) {
                    container.dispatcher.getEventHandler().handle((Event)new ContainerLocalizationRequestEvent(container, newResourceSet.getAllResourcesByVisibility()));
                } else {
                    container.dispatcher.getEventHandler().handle((Event)new ContainersLauncherEvent(container, ContainersLauncherEventType.CLEANUP_CONTAINER_FOR_REINIT));
                    resourcesPresent = true;
                }
                container.metrics.reInitingContainer();
                NMAuditLogger.logSuccess(container.user, "Container ReInitialization - Started", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
            }
            catch (Exception e) {
                LOG.error("Container [" + container.getContainerId() + "] re-initialization failure..", (Throwable)e);
                container.addDiagnostics(new String[]{"Error re-initializing due to[" + e.getMessage() + "]"});
                return ContainerState.RUNNING;
            }
            return resourcesPresent ? ContainerState.REINITIALIZING_AWAITING_KILL : ContainerState.REINITIALIZING;
        }

        protected ReInitializationContext createReInitContext(ContainerImpl container, ContainerEvent event) {
            ContainerReInitEvent reInitEvent = (ContainerReInitEvent)event;
            if (reInitEvent.getReInitLaunchContext() == null) {
                container.addDiagnostics(new String[]{"Container will be Restarted.\n"});
                return new ReInitializationContext(container.launchContext, container.resourceSet, container.canRollback() ? container.reInitContext.oldLaunchContext : null, container.canRollback() ? container.reInitContext.oldResourceSet : null);
            }
            container.addDiagnostics(new String[]{"Container will be Re-initialized.\n"});
            return new ReInitializationContext(reInitEvent.getReInitLaunchContext(), reInitEvent.getResourceSet(), reInitEvent.isAutoCommit() ? null : container.launchContext, reInitEvent.isAutoCommit() ? null : container.resourceSet);
        }
    }

    static class LocalizedTransition
    implements MultipleArcTransition<ContainerImpl, ContainerEvent, ContainerState> {
        LocalizedTransition() {
        }

        public ContainerState transition(ContainerImpl container, ContainerEvent event) {
            ContainerResourceLocalizedEvent rsrcEvent = (ContainerResourceLocalizedEvent)event;
            LocalResourceRequest resourceRequest = rsrcEvent.getResource();
            Path location = rsrcEvent.getLocation();
            Set<String> syms = container.resourceSet.resourceLocalized(resourceRequest, location);
            if (null == syms) {
                LOG.info("Localized resource " + resourceRequest + " for container " + container.containerId);
                return ContainerState.LOCALIZING;
            }
            if (ContainerImpl.shouldBeUploadedToSharedCache(container, resourceRequest)) {
                container.resourceSet.getResourcesToBeUploaded().put(resourceRequest, location);
            }
            if (!container.resourceSet.getPendingResources().isEmpty()) {
                return ContainerState.LOCALIZING;
            }
            container.dispatcher.getEventHandler().handle((Event)new ContainerLocalizationEvent(LocalizationEventType.CONTAINER_RESOURCES_LOCALIZED, container));
            container.sendScheduleEvent();
            container.metrics.endInitingContainer();
            if (container.recoveredStatus != NMStateStoreService.RecoveredContainerStatus.LAUNCHED && container.recoveredStatus != NMStateStoreService.RecoveredContainerStatus.COMPLETED) {
                container.dispatcher.getEventHandler().handle((Event)new SharedCacheUploadEvent(container.resourceSet.getResourcesToBeUploaded(), container.getLaunchContext(), container.getUser(), SharedCacheUploadEventType.UPLOAD));
            }
            return ContainerState.SCHEDULED;
        }
    }

    static class RequestResourcesTransition
    implements MultipleArcTransition<ContainerImpl, ContainerEvent, ContainerState> {
        RequestResourcesTransition() {
        }

        public ContainerState transition(ContainerImpl container, ContainerEvent event) {
            if (container.recoveredStatus == NMStateStoreService.RecoveredContainerStatus.COMPLETED) {
                container.sendFinishedEvents();
                return ContainerState.DONE;
            }
            if (container.recoveredStatus == NMStateStoreService.RecoveredContainerStatus.QUEUED) {
                return ContainerState.SCHEDULED;
            }
            if (container.recoveredAsKilled && container.recoveredStatus == NMStateStoreService.RecoveredContainerStatus.REQUESTED) {
                container.metrics.killedContainer();
                NMAuditLogger.logSuccess(container.user, "Container Finished - Killed", "ContainerImpl", container.containerId.getApplicationAttemptId().getApplicationId(), container.containerId);
                container.metrics.releaseContainer(container.containerTokenIdentifier.getResource());
                container.sendFinishedEvents();
                return ContainerState.DONE;
            }
            ContainerLaunchContext ctxt = container.launchContext;
            container.metrics.initingContainer();
            container.dispatcher.getEventHandler().handle((Event)new AuxServicesEvent(AuxServicesEventType.CONTAINER_INIT, container));
            Map csd = ctxt.getServiceData();
            if (csd != null) {
                for (Map.Entry service : csd.entrySet()) {
                    container.dispatcher.getEventHandler().handle((Event)new AuxServicesEvent(AuxServicesEventType.APPLICATION_INIT, container.user, container.containerId.getApplicationAttemptId().getApplicationId(), ((String)service.getKey()).toString(), (ByteBuffer)service.getValue()));
                }
            }
            container.containerLocalizationStartTime = clock.getTime();
            Map cntrRsrc = ctxt.getLocalResources();
            if (!cntrRsrc.isEmpty()) {
                try {
                    Map<LocalResourceVisibility, Collection<LocalResourceRequest>> req = container.resourceSet.addResources(ctxt.getLocalResources());
                    container.dispatcher.getEventHandler().handle((Event)new ContainerLocalizationRequestEvent(container, req));
                }
                catch (URISyntaxException e) {
                    LOG.warn("Failed to parse resource-request", (Throwable)e);
                    container.cleanup();
                    container.metrics.endInitingContainer();
                    return ContainerState.LOCALIZATION_FAILED;
                }
                return ContainerState.LOCALIZING;
            }
            container.sendScheduleEvent();
            container.metrics.endInitingContainer();
            return ContainerState.SCHEDULED;
        }
    }

    static class NotifyContainerSchedulerOfUpdateTransition
    extends UpdateTransition {
        NotifyContainerSchedulerOfUpdateTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            UpdateContainerTokenEvent updateEvent = (UpdateContainerTokenEvent)event;
            ContainerTokenIdentifier originalToken = container.containerTokenIdentifier;
            super.transition(container, updateEvent);
            container.dispatcher.getEventHandler().handle((Event)new UpdateContainerSchedulerEvent(container, originalToken, updateEvent));
        }
    }

    static class UpdateTransition
    extends ContainerTransition {
        UpdateTransition() {
        }

        @Override
        public void transition(ContainerImpl container, ContainerEvent event) {
            UpdateContainerTokenEvent updateEvent = (UpdateContainerTokenEvent)event;
            container.setContainerTokenIdentifier(updateEvent.getUpdatedToken());
            try {
                container.context.getNMStateStore().storeContainerUpdateToken(container.containerId, container.getContainerTokenIdentifier());
            }
            catch (IOException e) {
                LOG.warn("Could not store container [" + container.containerId + "] update..", (Throwable)e);
            }
        }
    }

    static class ContainerTransition
    implements SingleArcTransition<ContainerImpl, ContainerEvent> {
        ContainerTransition() {
        }

        public void transition(ContainerImpl container, ContainerEvent event) {
        }
    }

    private static final class ReInitializationContext {
        private final ContainerLaunchContext newLaunchContext;
        private final ResourceSet newResourceSet;
        private final ContainerLaunchContext oldLaunchContext;
        private final ResourceSet oldResourceSet;
        private boolean isRollback = false;

        private ReInitializationContext(ContainerLaunchContext newLaunchContext, ResourceSet newResourceSet, ContainerLaunchContext oldLaunchContext, ResourceSet oldResourceSet) {
            this.newLaunchContext = newLaunchContext;
            this.newResourceSet = newResourceSet;
            this.oldLaunchContext = oldLaunchContext;
            this.oldResourceSet = oldResourceSet;
        }

        private boolean canRollback() {
            return this.oldLaunchContext != null;
        }

        private ResourceSet mergedResourceSet(ResourceSet current) {
            if (this.isRollback) {
                return this.newResourceSet;
            }
            if (current == this.newResourceSet) {
                return current;
            }
            return ResourceSet.merge(current, this.newResourceSet);
        }

        private ReInitializationContext createContextForRollback() {
            ReInitializationContext cntxt = new ReInitializationContext(this.oldLaunchContext, this.oldResourceSet, null, null);
            cntxt.isRollback = true;
            return cntxt;
        }
    }
}

