/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.health;

import com.google.common.annotations.VisibleForTesting;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.server.nodemanager.health.HealthReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimedHealthReporterService
extends AbstractService
implements HealthReporter {
    private static final Logger LOG = LoggerFactory.getLogger(TimedHealthReporterService.class);
    private boolean isHealthy = true;
    private String healthReport = "";
    private long lastReportedTime = System.currentTimeMillis();
    private Timer timer;
    private TimerTask task;
    private long intervalMs;

    TimedHealthReporterService(String name, long intervalMs) {
        super(name);
        this.intervalMs = intervalMs;
    }

    @VisibleForTesting
    void setTimerTask(TimerTask timerTask) {
        this.task = timerTask;
    }

    @VisibleForTesting
    TimerTask getTimerTask() {
        return this.task;
    }

    public void serviceStart() throws Exception {
        if (this.task == null) {
            throw new Exception("Health reporting task hasn't been set!");
        }
        this.timer = new Timer("HealthReporterService-Timer", true);
        this.timer.scheduleAtFixedRate(this.task, 0L, this.intervalMs);
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.serviceStop();
    }

    @Override
    public boolean isHealthy() {
        return this.isHealthy;
    }

    protected synchronized void setHealthy(boolean healthy) {
        this.isHealthy = healthy;
    }

    @Override
    public String getHealthReport() {
        return this.healthReport;
    }

    private synchronized void setHealthReport(String report) {
        this.healthReport = report;
    }

    @Override
    public long getLastHealthReportTime() {
        return this.lastReportedTime;
    }

    private synchronized void setLastReportedTime(long lastReportedTime) {
        this.lastReportedTime = lastReportedTime;
    }

    synchronized void setHealthyWithoutReport() {
        this.setHealthy(true);
        this.setHealthReport("");
        this.setLastReportedTime(System.currentTimeMillis());
    }

    synchronized void setUnhealthyWithReport(String output) {
        LOG.info("Health status being set as: \"" + output + "\".");
        this.setHealthy(false);
        this.setHealthReport(output);
        this.setLastReportedTime(System.currentTimeMillis());
    }
}

