/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PreemptableResourceScheduler;

public class SchedulingMonitor
extends AbstractService {
    private final SchedulingEditPolicy scheduleEditPolicy;
    private static final Log LOG = LogFactory.getLog(SchedulingMonitor.class);
    private ScheduledExecutorService ses;
    private ScheduledFuture<?> handler;
    private volatile boolean stopped;
    private long monitorInterval;
    private RMContext rmContext;

    public SchedulingMonitor(RMContext rmContext, SchedulingEditPolicy scheduleEditPolicy) {
        super("SchedulingMonitor (" + scheduleEditPolicy.getPolicyName() + ")");
        this.scheduleEditPolicy = scheduleEditPolicy;
        this.rmContext = rmContext;
    }

    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    @VisibleForTesting
    public synchronized SchedulingEditPolicy getSchedulingEditPolicy() {
        return this.scheduleEditPolicy;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.scheduleEditPolicy.init(conf, this.rmContext, (PreemptableResourceScheduler)this.rmContext.getScheduler());
        this.monitorInterval = this.scheduleEditPolicy.getMonitoringInterval();
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        assert (!this.stopped) : "starting when already stopped";
        this.ses = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(SchedulingMonitor.this.getName());
                return t;
            }
        });
        this.handler = this.ses.scheduleAtFixedRate(new PreemptionChecker(), 0L, this.monitorInterval, TimeUnit.MILLISECONDS);
        super.serviceStart();
    }

    public void serviceStop() throws Exception {
        this.stopped = true;
        if (this.handler != null) {
            LOG.info((Object)("Stop " + this.getName()));
            this.handler.cancel(true);
            this.ses.shutdown();
        }
        super.serviceStop();
    }

    @VisibleForTesting
    public void invokePolicy() {
        this.scheduleEditPolicy.editSchedule();
    }

    private class PreemptionChecker
    implements Runnable {
        private PreemptionChecker() {
        }

        @Override
        public void run() {
            try {
                SchedulingMonitor.this.invokePolicy();
            }
            catch (YarnRuntimeException e) {
                LOG.error((Object)"YarnRuntimeException raised while executing preemption checker, skip this run..., exception=", (Throwable)e);
            }
        }
    }
}

