/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import org.apache.commons.logging.Log;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;

public class SchedulerAppUtils {
    public static boolean isPlaceBlacklisted(SchedulerApplicationAttempt application, SchedulerNode node, Log log) {
        if (application.isPlaceBlacklisted(node.getNodeName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping 'host' " + node.getNodeName() + " for " + application.getApplicationId() + " since it has been blacklisted"));
            }
            return true;
        }
        if (application.isPlaceBlacklisted(node.getRackName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping 'rack' " + node.getRackName() + " for " + application.getApplicationId() + " since it has been blacklisted"));
            }
            return true;
        }
        return false;
    }
}

