/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.IMetadataIndexEntry;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class MeasurementMetadataIndexEntry
implements IMetadataIndexEntry {
    private String name;
    private long offset;

    public MeasurementMetadataIndexEntry(String name, long offset) {
        this.name = name;
        this.offset = offset;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.writeVar(this.name, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.offset, outputStream);
    }

    @Override
    public Comparable getCompareKey() {
        return this.name;
    }

    @Override
    public boolean isDeviceLevel() {
        return false;
    }

    public static MeasurementMetadataIndexEntry deserializeFrom(ByteBuffer buffer) {
        String name = ReadWriteIOUtils.readVarIntString(buffer);
        long offset = ReadWriteIOUtils.readLong(buffer);
        return new MeasurementMetadataIndexEntry(name, offset);
    }

    public static MeasurementMetadataIndexEntry deserializeFrom(InputStream inputStream) throws IOException {
        String name = ReadWriteIOUtils.readVarIntString(inputStream);
        long offset = ReadWriteIOUtils.readLong(inputStream);
        return new MeasurementMetadataIndexEntry(name, offset);
    }

    public String toString() {
        return "<" + this.name + "," + this.offset + ">";
    }
}

