/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PlainDeviceID
implements IDeviceID {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(PlainDeviceID.class) + RamUsageEstimator.shallowSizeOfInstance(String.class);
    private final String deviceID;

    public PlainDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlainDeviceID)) {
            return false;
        }
        PlainDeviceID that = (PlainDeviceID)o;
        return Objects.equals(this.deviceID, that.deviceID);
    }

    public int hashCode() {
        return this.deviceID.hashCode();
    }

    public String toString() {
        return "PlainDeviceID{deviceID='" + this.deviceID + '\'' + '}';
    }

    public String toStringID() {
        return this.deviceID;
    }

    @Override
    public int serialize(ByteBuffer byteBuffer) {
        return ReadWriteIOUtils.write(this.deviceID, byteBuffer);
    }

    @Override
    public int serialize(OutputStream outputStream) throws IOException {
        return ReadWriteIOUtils.writeVar(this.deviceID, outputStream);
    }

    @Override
    public byte[] getBytes() {
        return this.deviceID.getBytes();
    }

    @Override
    public boolean isEmpty() {
        return this.deviceID.isEmpty();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOfCharArray((int)this.deviceID.length());
    }

    public static PlainDeviceID deserialize(ByteBuffer byteBuffer) {
        return new PlainDeviceID(ReadWriteIOUtils.readString(byteBuffer));
    }

    @Override
    public int compareTo(IDeviceID other) {
        if (!(other instanceof PlainDeviceID)) {
            throw new IllegalArgumentException();
        }
        return this.deviceID.compareTo(((PlainDeviceID)other).deviceID);
    }
}

