/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.query.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.reader.series.AbstractFileSeriesReader;

public class DataSetWithoutTimeGenerator
extends QueryDataSet {
    private final List<AbstractFileSeriesReader> readers;
    private List<BatchData> batchDataList;
    private List<Boolean> hasDataRemaining;
    private PriorityQueue<Long> timeHeap;
    private Set<Long> timeSet;

    public DataSetWithoutTimeGenerator(List<Path> paths, List<TSDataType> dataTypes, List<AbstractFileSeriesReader> readers) throws IOException {
        super(paths, dataTypes);
        this.readers = readers;
        this.initHeap();
    }

    private void initHeap() throws IOException {
        this.hasDataRemaining = new ArrayList<Boolean>();
        this.batchDataList = new ArrayList<BatchData>();
        this.timeHeap = new PriorityQueue();
        this.timeSet = new HashSet<Long>();
        for (int i = 0; i < this.paths.size(); ++i) {
            AbstractFileSeriesReader reader = this.readers.get(i);
            if (!reader.hasNextBatch()) {
                this.batchDataList.add(new BatchData());
                this.hasDataRemaining.add(false);
                continue;
            }
            this.batchDataList.add(reader.nextBatch());
            this.hasDataRemaining.add(true);
        }
        for (BatchData data : this.batchDataList) {
            if (!data.hasCurrent()) continue;
            this.timeHeapPut(data.currentTime());
        }
    }

    @Override
    public boolean hasNextWithoutConstraint() {
        return !this.timeHeap.isEmpty();
    }

    @Override
    public RowRecord nextWithoutConstraint() throws IOException {
        long minTime = this.timeHeapGet();
        RowRecord rowRecord = new RowRecord(minTime);
        for (int i = 0; i < this.paths.size(); ++i) {
            if (Boolean.FALSE.equals(this.hasDataRemaining.get(i))) {
                rowRecord.addField(null);
                continue;
            }
            BatchData data = this.batchDataList.get(i);
            if (data.hasCurrent() && data.currentTime() == minTime) {
                Field field = this.putValueToField(data);
                data.next();
                if (!data.hasCurrent()) {
                    AbstractFileSeriesReader reader = this.readers.get(i);
                    if (reader.hasNextBatch()) {
                        data = reader.nextBatch();
                        if (data.hasCurrent()) {
                            this.batchDataList.set(i, data);
                            this.timeHeapPut(data.currentTime());
                        } else {
                            this.hasDataRemaining.set(i, false);
                        }
                    } else {
                        this.hasDataRemaining.set(i, false);
                    }
                } else {
                    this.timeHeapPut(data.currentTime());
                }
                rowRecord.addField(field);
                continue;
            }
            rowRecord.addField(null);
        }
        return rowRecord;
    }

    private void timeHeapPut(long time) {
        if (!this.timeSet.contains(time)) {
            this.timeSet.add(time);
            this.timeHeap.add(time);
        }
    }

    private Long timeHeapGet() {
        Long t = this.timeHeap.poll();
        this.timeSet.remove(t);
        return t;
    }

    private Field putValueToField(BatchData col) {
        TSDataType type = col.getDataType();
        Field field = type == TSDataType.VECTOR ? new Field(col.getVector()[0].getDataType()) : new Field(col.getDataType());
        switch (col.getDataType()) {
            case BOOLEAN: {
                field.setBoolV(col.getBoolean());
                break;
            }
            case INT32: {
                field.setIntV(col.getInt());
                break;
            }
            case INT64: {
                field.setLongV(col.getLong());
                break;
            }
            case FLOAT: {
                field.setFloatV(col.getFloat());
                break;
            }
            case DOUBLE: {
                field.setDoubleV(col.getDouble());
                break;
            }
            case TEXT: {
                field.setBinaryV(col.getBinary());
                break;
            }
            case VECTOR: {
                Field.setTsPrimitiveValue(col.getVector()[0], field);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("UnSupported" + col.getDataType());
            }
        }
        return field;
    }
}

