/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.config;

import com.google.inject.internal.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.components.Installer;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderAware;

public abstract class InstallerAbstract
implements Installer,
IsisConfigurationBuilderAware {
    private final String type;
    private final String name;
    private IsisConfigurationBuilder isisConfigurationBuilder;
    private IsisConfiguration configuration;

    public InstallerAbstract(String type, String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getConfigurationResources() {
        ArrayList resourceList = Lists.newArrayList();
        String componentFile = this.getType() + ".properties";
        resourceList.add(componentFile);
        String componentImplementationFile = this.getType() + "_" + this.getName() + ".properties";
        resourceList.add(componentImplementationFile);
        this.addConfigurationResources(resourceList);
        return Collections.unmodifiableList(resourceList);
    }

    protected void addConfigurationResources(List<String> configurationResources) {
    }

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void setConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        if (this.configuration != null) {
            throw new IllegalStateException("A IsisConfiguration has already been provided.");
        }
        this.isisConfigurationBuilder = isisConfigurationBuilder;
    }

    public void setConfiguration(IsisConfiguration configuration) {
        if (this.isisConfigurationBuilder != null) {
            throw new IllegalStateException("A IsisConfiguration has already been provided.");
        }
        this.configuration = configuration;
    }

    public IsisConfiguration getConfiguration() {
        if (this.isisConfigurationBuilder != null) {
            return this.isisConfigurationBuilder.getConfiguration();
        }
        if (this.configuration != null) {
            return this.configuration;
        }
        throw new IllegalStateException("Neither a ConfigurationBuilder nor Configuration has not been provided");
    }

    protected static List<Class<?>> listOf(Class<?> ... classes) {
        return Collections.unmodifiableList(Lists.newArrayList((Object[])classes));
    }

    protected static List<Class<?>> listOf(List<Class<?>> classList, Class<?> ... classes) {
        ArrayList arrayList = Lists.newArrayList((Object[])classes);
        arrayList.addAll(0, classList);
        return Collections.unmodifiableList(arrayList);
    }
}

