/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.encoding;

import java.io.IOException;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtendedDecorator;
import org.apache.log4j.Logger;

public class DebugDataOutputExtended
extends DataOutputExtendedDecorator {
    private static final Logger LOG = Logger.getLogger(DebugDataOutputExtended.class);

    public DebugDataOutputExtended(DataOutputExtended underlying) {
        super(underlying);
    }

    @Override
    public void writeBoolean(boolean flag) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("boolean: " + flag));
        }
        super.writeBoolean(flag);
    }

    @Override
    public void writeBytes(byte[] value) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("bytes: (" + value.length + ") " + new String(value)));
        }
        super.writeBytes(value);
    }

    @Override
    public void writeByte(int value) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("byte: " + value));
        }
        super.writeByte(value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("int: " + value));
        }
        super.writeInt(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("long: " + value));
        }
        super.writeLong(value);
    }

    @Override
    public void writeEncodable(Object object) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>> object: (" + object + ")"));
        }
        super.writeEncodable(object);
    }

    @Override
    public void writeEncodables(Object[] objects) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>> objects x" + objects.length));
        }
        super.writeEncodables(objects);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("string: " + str));
        }
        super.writeUTF(str);
    }

    @Override
    public void writeUTFs(String[] strings) throws IOException {
        if (LOG.isDebugEnabled()) {
            StringBuffer l = new StringBuffer();
            for (int i = 0; i < strings.length; ++i) {
                if (i > 0) {
                    l.append(", ");
                }
                l.append(strings[i]);
            }
            LOG.debug((Object)("list: " + l));
        }
        super.writeUTFs(strings);
    }
}

