/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.ensure;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public final class Ensure {
    private Ensure() {
    }

    public static <T> T ensureThatArg(T object, Matcher<T> matcher) {
        if (!matcher.matches(object)) {
            throw new IllegalArgumentException("illegal argument, expected: " + Ensure.descriptionOf(matcher));
        }
        return object;
    }

    public static <T> T ensureThatArg(T arg, Matcher<T> matcher, String message) {
        if (!matcher.matches(arg)) {
            throw new IllegalArgumentException(message);
        }
        return arg;
    }

    public static <T> T ensureThatState(T field, Matcher<T> matcher) {
        if (!matcher.matches(field)) {
            throw new IllegalStateException("illegal argument, expected: " + Ensure.descriptionOf(matcher));
        }
        return field;
    }

    public static <T> T ensureThatState(T field, Matcher<T> matcher, String message) {
        if (!matcher.matches(field)) {
            throw new IllegalStateException(message);
        }
        return field;
    }

    public static <T> T ensureThatContext(T contextProperty, Matcher<T> matcher) {
        if (!matcher.matches(contextProperty)) {
            throw new IllegalThreadStateException("illegal argument, expected: " + Ensure.descriptionOf(matcher));
        }
        return contextProperty;
    }

    public static <T> T ensureThatContext(T contextProperty, Matcher<T> matcher, String message) {
        if (!matcher.matches(contextProperty)) {
            throw new IllegalThreadStateException(message);
        }
        return contextProperty;
    }

    private static <T> String descriptionOf(Matcher<T> matcher) {
        StringDescription stringDescription = new StringDescription();
        matcher.describeTo((Description)stringDescription);
        String description = stringDescription.toString();
        return description;
    }
}

