/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JavaClassUtils {
    private static final String JAVA_CLASS_PREFIX = "java.";
    private static Map<String, Class<?>> builtInClasses = new HashMap();

    private static void put(Class<?> cls) {
        builtInClasses.put(cls.getName(), cls);
    }

    private JavaClassUtils() {
    }

    public static Class<?> getBuiltIn(String name) {
        return builtInClasses.get(name);
    }

    public static String getSuperclass(Class<?> type) {
        Class<?> superType = type.getSuperclass();
        if (superType == null) {
            return null;
        }
        return superType.getName();
    }

    public static boolean isAbstract(Class<?> type) {
        return Modifier.isAbstract(type.getModifiers());
    }

    public static boolean isFinal(Class<?> type) {
        return Modifier.isFinal(type.getModifiers());
    }

    public static boolean isPublic(Class<?> type) {
        return Modifier.isPublic(type.getModifiers());
    }

    public static boolean isJavaClass(Class<?> type) {
        return type.getName().startsWith(JAVA_CLASS_PREFIX) || type.getName().startsWith("sun.");
    }

    public static boolean isPublic(Method method) {
        return Modifier.isPublic(method.getModifiers());
    }

    public static List<Class<?>> toClasses(List<Object> objectList) {
        ArrayList classList = new ArrayList();
        for (Object service : objectList) {
            classList.add(service.getClass());
        }
        return classList;
    }

    public static Class<?> implementingClassOrNull(Class<?> classCandidate, Class<?> requiredClass, Class<?> constructorParamType) {
        if (classCandidate == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(classCandidate)) {
            return null;
        }
        try {
            classCandidate.getConstructor(constructorParamType);
        }
        catch (NoSuchMethodException ex) {
            try {
                classCandidate.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        int modifiers = classCandidate.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return null;
        }
        return classCandidate;
    }

    public static Class<?> implementingClassOrNull(String classCandidateName, Class<?> requiredClass, Class<?> constructorParamType) {
        if (classCandidateName == null) {
            return null;
        }
        Class<?> classCandidate = null;
        try {
            classCandidate = Class.forName(classCandidateName);
            return JavaClassUtils.implementingClassOrNull(classCandidate, requiredClass, constructorParamType);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean directlyImplements(Class<?> cls, Class<?> interfaceType) {
        for (Class<?> directlyImplementedInterface : cls.getInterfaces()) {
            if (directlyImplementedInterface != interfaceType) continue;
            return true;
        }
        return false;
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    static {
        JavaClassUtils.put(Void.TYPE);
        JavaClassUtils.put(Boolean.TYPE);
        JavaClassUtils.put(Character.TYPE);
        JavaClassUtils.put(Byte.TYPE);
        JavaClassUtils.put(Short.TYPE);
        JavaClassUtils.put(Integer.TYPE);
        JavaClassUtils.put(Long.TYPE);
        JavaClassUtils.put(Float.TYPE);
        JavaClassUtils.put(Double.TYPE);
    }
}

