/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public final class StringUtils {
    private static final char CARRIAGE_RETURN = '\n';
    private static final char LINE_FEED = '\r';

    private StringUtils() {
    }

    public static String naturalName(String name) {
        int pos;
        for (pos = 0; pos < name.length() && Character.isLowerCase(name.charAt(pos)); ++pos) {
        }
        if (pos == name.length()) {
            return "invalid name";
        }
        return StringUtils.naturalize(name, pos);
    }

    public static String naturalize(String name) {
        return StringUtils.naturalize(name, 0);
    }

    private static String naturalize(String name, int startingPosition) {
        if (name.length() <= startingPosition) {
            throw new IllegalArgumentException("string shorter than starting position provided");
        }
        StringBuffer s = new StringBuffer(name.length() - startingPosition);
        for (int j = startingPosition; j < name.length(); ++j) {
            if (j > startingPosition && StringUtils.isStartOfNewWord(name.charAt(j), name.charAt(j - 1))) {
                s.append(' ');
            }
            if (j == startingPosition) {
                s.append(Character.toUpperCase(name.charAt(j)));
                continue;
            }
            s.append(name.charAt(j));
        }
        String str = s.toString();
        return str;
    }

    private static boolean isStartOfNewWord(char c, char previousChar) {
        return Character.isUpperCase(c) || Character.isDigit(c) && !Character.isDigit(previousChar);
    }

    public static String simpleName(String str) {
        int lastDot = str.lastIndexOf(46);
        if (lastDot == -1) {
            return str;
        }
        if (lastDot == str.length() - 1) {
            throw new IllegalArgumentException("Name cannot end in '.'");
        }
        return str.substring(lastDot + 1);
    }

    public static String camel(String name) {
        StringBuffer b = new StringBuffer(name.length());
        StringTokenizer t = new StringTokenizer(name);
        b.append(t.nextToken());
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            b.append(token.substring(0, 1).toUpperCase());
            b.append(token.substring(1));
        }
        return b.toString();
    }

    public static String pascal(String name) {
        return StringUtils.capitalize(StringUtils.camel(name));
    }

    public static String memberIdFor(String member) {
        return StringUtils.lowerLeading(StringUtils.camel(member));
    }

    public static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String lowerFirst(String str) {
        if (StringUtils.isNullOrEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase();
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public static String lowerLeading(String str) {
        return StringUtils.lowerFirst(str);
    }

    public static String firstWord(String line) {
        String[] split = line.split(" ");
        return split[0];
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean nullSafeEquals(String str1, String str2) {
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean in(String str, String[] strings) {
        for (String strCandidate : strings) {
            if (!strCandidate.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static String combine(List<String> list) {
        StringBuffer buf = new StringBuffer();
        for (String message : list) {
            if (list.size() > 1) {
                buf.append("; ");
            }
            buf.append(message);
        }
        return buf.toString();
    }

    public static String combinePaths(String path, String ... furtherPaths) {
        StringBuilder buf = new StringBuilder(path);
        for (String furtherPath : furtherPaths) {
            if (buf.charAt(buf.length() - 1) != File.separatorChar) {
                buf.append(File.separatorChar);
            }
            buf.append(furtherPath);
        }
        return buf.toString();
    }

    public static List<String> splitOnCommas(String commaSeparatedList) {
        if (commaSeparatedList == null) {
            return null;
        }
        String removeLeadingWhiteSpace = StringUtils.removeLeadingWhiteSpace(commaSeparatedList);
        if (removeLeadingWhiteSpace.length() == 0) {
            return Collections.emptyList();
        }
        String[] splitAsArray = removeLeadingWhiteSpace.split("\\W*,\\W*");
        return Arrays.asList(splitAsArray);
    }

    public static String commaSeparatedClassNames(List<Object> objects) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (Object object : objects) {
            if (i++ > 0) {
                buf.append(',');
            }
            buf.append(object.getClass().getName());
        }
        return buf.toString();
    }

    public static String lineSeparated(String string) {
        StringBuilder buf = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        boolean lastWasLineFeed = false;
        for (char c : string.toCharArray()) {
            boolean isCarriageReturn;
            boolean isLineFeed = c == '\r';
            boolean bl = isCarriageReturn = c == '\n';
            if (isCarriageReturn) {
                buf.append(lineSeparator);
                lastWasLineFeed = false;
                continue;
            }
            if (lastWasLineFeed) {
                buf.append('\r');
            }
            if (isLineFeed) {
                lastWasLineFeed = true;
                continue;
            }
            buf.append(c);
            lastWasLineFeed = false;
        }
        if (lastWasLineFeed) {
            buf.append('\r');
        }
        return buf.toString();
    }

    public static String removeTabs(String text) {
        if (text.indexOf(9) == -1) {
            return text;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\t') continue;
            buf.append(text.charAt(i));
        }
        return buf.toString();
    }

    public static String removeLeadingWhiteSpace(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("^\\W*", "");
    }

    public static String stripNewLines(String str) {
        return str.replaceAll("[\r\n]", "");
    }

    public static String stripLeadingSlash(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        if (path.length() < 2) {
            return "";
        }
        return path.substring(1);
    }

    public static String normalized(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\s+", " ");
    }

    public static String[] normalized(String ... strings) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (String string : strings) {
            stringList.add(StringUtils.normalized(string));
        }
        return stringList.toArray(new String[0]);
    }

    public static String removePrefix(String name, String prefix) {
        if (name.startsWith(prefix)) {
            return name.substring(prefix.length());
        }
        return name;
    }
}

