/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.xml.ContentWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlFile {
    private static final String[] ESCAPE_STRING = new String[]{"&amp;", "&lt;", "&gt;", "&quot;", "&apos;"};
    private static final String[] SPECIAL_CHARACTERS = new String[]{"&", "<", ">", "\"", "'"};
    private final String charset;
    private final File directory;

    public static String getValueWithSpecialsEscaped(String s) {
        String result = s;
        for (int i = 0; i < SPECIAL_CHARACTERS.length; ++i) {
            String special = SPECIAL_CHARACTERS[i];
            int pos = -1;
            while ((pos = result.indexOf(special, pos + 1)) >= 0) {
                result = result.substring(0, pos) + ESCAPE_STRING[i] + result.substring(pos + special.length());
            }
        }
        return result;
    }

    public XmlFile(String charset, String directory) {
        this.directory = new File(directory);
        this.createDirectoryIfRequired();
        this.charset = charset;
    }

    private void createDirectoryIfRequired() {
        if (this.directory.exists()) {
            return;
        }
        this.directory.mkdirs();
    }

    public File getDirectory() {
        return this.directory;
    }

    private File file(String fileName) {
        return new File(this.directory, fileName + ".xml");
    }

    public void writeXml(String name, ContentWriter writer) {
        try {
            OutputStreamWriter pw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file(name)), this.charset);
            pw.write("<?xml version=\"1.0\" encoding=\"" + this.charset + "\" ?>\n");
            pw.write("\n");
            writer.write(pw);
            pw.write("\n");
            pw.close();
        }
        catch (IOException e) {
            throw new IsisException("Problems writing data files", e);
        }
    }

    public boolean parse(ContentHandler handler, String fileName) {
        XMLReader parser;
        try {
            parser = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            try {
                parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException e2) {
                try {
                    parser = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                }
                catch (SAXException failed) {
                    throw new IsisException("Couldn't locate a SAX parser");
                }
            }
        }
        try {
            parser.setContentHandler(handler);
            parser.parse(new InputSource(new InputStreamReader((InputStream)new FileInputStream(this.file(fileName)), this.charset)));
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new IsisException("Error reading XML file", e);
        }
        catch (SAXParseException e) {
            throw new IsisException("Error while parsing: " + e.getMessage() + " in " + this.file(fileName) + ")", e);
        }
        catch (SAXException e) {
            throw new IsisException("Error in file " + this.file(fileName) + " ", e);
        }
    }

    public void delete(String fileName) {
        this.file(fileName).delete();
    }

    public boolean isFixturesInstalled() {
        String[] list = this.directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        return list.length > 0;
    }
}

