/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facetdecorators.i18n.resourcebundle.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.isis.applib.Identifier;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.progmodel.facetdecorators.i18n.I18nManager;
import org.apache.log4j.Logger;

public class I18nManagerUsingResourceBundle
implements I18nManager {
    private static final Logger LOG = Logger.getLogger(I18nManagerUsingResourceBundle.class);
    private static final String BASE_FILE_NAME = "i18n";
    private static final String MEMBER_TYPE_PROPERTY = "property";
    private static final String MEMBER_TYPE_COLLECTION = "collection";
    private static final String MEMBER_TYPE_ACTION = "action";
    private static final String MEMBER_TYPE_PARAMETER = "parameter";
    private static final String TEXT_TYPE_NAME = "name";
    private static final String TEXT_TYPE_DESCRIPTION = "description";
    private static final String TEXT_TYPE_HELP = "help";
    private ResourceBundle bundle;
    private final IsisConfiguration configuration;

    public I18nManagerUsingResourceBundle(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        try {
            this.bundle = ResourceBundle.getBundle(BASE_FILE_NAME);
        }
        catch (MissingResourceException e) {
            LOG.warn((Object)("Missing resource bundle: " + e.getMessage()));
        }
    }

    public void shutdown() {
    }

    @Override
    public String getName(Identifier identifier) {
        return this.internalizedTextForClassMember(identifier, TEXT_TYPE_NAME);
    }

    @Override
    public String getDescription(Identifier identifier) {
        return this.internalizedTextForClassMember(identifier, TEXT_TYPE_DESCRIPTION);
    }

    @Override
    public String getHelp(Identifier identifier) {
        return this.internalizedTextForClassMember(identifier, TEXT_TYPE_HELP);
    }

    private String internalizedTextForClassMember(Identifier identifier, String textType) {
        if (this.bundle == null) {
            return null;
        }
        List<String> key = I18nManagerUsingResourceBundle.buildMemberTypeKey(identifier, textType);
        return this.lookupTextFromBundle(key);
    }

    private static List<String> buildMemberTypeKey(Identifier identifier, String textType) {
        ArrayList keys = Lists.newArrayList();
        if (identifier.isPropertyOrCollection()) {
            keys.add(I18nManagerUsingResourceBundle.buildMemberTypeKey(identifier, textType, MEMBER_TYPE_PROPERTY));
            keys.add(I18nManagerUsingResourceBundle.buildMemberTypeKey(identifier, textType, MEMBER_TYPE_COLLECTION));
        } else {
            keys.add(I18nManagerUsingResourceBundle.buildMemberTypeKey(identifier, textType, MEMBER_TYPE_ACTION));
        }
        return keys;
    }

    private static String buildMemberTypeKey(Identifier identifier, String textType, String memberType) {
        StringBuilder sb = new StringBuilder();
        sb.append(identifier.getClassName()).append(".");
        sb.append(memberType);
        String memberName = identifier.getMemberName();
        if (!StringUtils.isNullOrEmpty((String)memberName)) {
            sb.append(".").append(memberName);
        }
        sb.append(".").append(textType);
        return sb.toString();
    }

    @Override
    public List<String> getParameterNames(Identifier identifier) {
        return this.internalizedTextForParameter(identifier, TEXT_TYPE_NAME);
    }

    private List<String> internalizedTextForParameter(Identifier identifier, String textType) {
        if (this.bundle == null) {
            return null;
        }
        ArrayList internalizedText = Lists.newArrayList();
        List memberParameterNames = identifier.getMemberParameterNames();
        int paramNum = 0;
        for (String dummy : memberParameterNames) {
            String key = I18nManagerUsingResourceBundle.buildParameterTypeKey(identifier, textType, paramNum);
            internalizedText.add(this.lookupTextFromBundle(key));
            ++paramNum;
        }
        return internalizedText;
    }

    private static String buildParameterTypeKey(Identifier identifier, String textType, int paramNum) {
        return identifier.getClassName() + "." + MEMBER_TYPE_ACTION + "." + identifier.getMemberName() + "." + MEMBER_TYPE_PARAMETER + (paramNum + 1) + "." + textType;
    }

    private String lookupTextFromBundle(List<String> keys) {
        for (String key : keys) {
            String text = this.lookupTextFromBundle(key);
            if (text == null) continue;
            return text;
        }
        return null;
    }

    private String lookupTextFromBundle(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

