/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.actions.validate.method;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.actions.validate.method.ActionValidationFacetViaMethod;

public class ActionValidationFacetViaValidateMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"validate"};

    public ActionValidationFacetViaValidateMethodFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachValidatingAdvisorFacetForValidateMethodIfFound(processMethodContext);
    }

    private void attachValidatingAdvisorFacetForValidateMethodIfFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Class cls = processMethodContext.getCls();
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.capitalizeName((String)actionMethod.getName());
        Class<?>[] paramTypes = actionMethod.getParameterTypes();
        MethodScope onClass = MethodScope.scopeFor((Method)actionMethod);
        Method validateMethod = MethodFinderUtils.findMethod(cls, onClass, "validate" + capitalizedName, String.class, paramTypes);
        if (validateMethod == null) {
            return;
        }
        processMethodContext.removeMethod(validateMethod);
        FacetHolder facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new ActionValidationFacetViaMethod(validateMethod, facetedMethod));
    }
}

