/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.clear;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.adapter.ObjectDirtier;
import org.apache.isis.core.metamodel.adapter.ObjectDirtierAware;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacet;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.collections.clear.CollectionClearFacetViaAccessor;
import org.apache.isis.core.progmodel.facets.collections.clear.CollectionClearFacetViaMethod;

public class CollectionClearFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterMapAware,
ObjectDirtierAware {
    private static final String[] PREFIXES = new String[]{"clear"};
    private AdapterMap adapterMap;
    private ObjectDirtier objectDirtier;

    public CollectionClearFacetFactory() {
        super(FeatureType.COLLECTIONS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachCollectionClearFacets(processMethodContext);
    }

    private void attachCollectionClearFacets(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.javaBaseName((String)getMethod.getName());
        Class cls = processMethodContext.getCls();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "clear" + capitalizedName, Void.TYPE, null);
        processMethodContext.removeMethod(method);
        FacetHolder collection = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)this.createCollectionClearFacet(method, getMethod, collection));
    }

    private CollectionClearFacet createCollectionClearFacet(Method clearMethodIfAny, Method accessorMethod, FacetHolder collection) {
        if (clearMethodIfAny != null) {
            return new CollectionClearFacetViaMethod(clearMethodIfAny, collection);
        }
        return new CollectionClearFacetViaAccessor(accessorMethod, collection, this.getAdapterMap(), this.getObjectDirtier());
    }

    protected AdapterMap getAdapterMap() {
        return this.adapterMap;
    }

    public void setAdapterMap(AdapterMap adapterMap) {
        this.adapterMap = adapterMap;
    }

    protected ObjectDirtier getObjectDirtier() {
        return this.objectDirtier;
    }

    public void setObjectDirtier(ObjectDirtier objectDirtier) {
        this.objectDirtier = objectDirtier;
    }
}

