/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.collection;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.collections.CollectionFacetAbstract;
import org.apache.isis.core.progmodel.facets.collections.collection.ObjectToAdapterTransformer;

public class JavaCollectionFacet
extends CollectionFacetAbstract {
    private final AdapterMap adapterMap;

    public JavaCollectionFacet(FacetHolder holder, AdapterMap adapterManager) {
        super(holder);
        this.adapterMap = adapterManager;
    }

    public Collection<ObjectAdapter> collection(ObjectAdapter wrappedCollection) {
        Collection<?> collectionOfUnderlying = this.collectionOfUnderlying(wrappedCollection);
        return CollectionUtils.collect(collectionOfUnderlying, (Transformer)new ObjectToAdapterTransformer(this.getAdapterMap()));
    }

    public ObjectAdapter firstElement(ObjectAdapter collection) {
        Iterator iterator = this.iterator(collection);
        return iterator.hasNext() ? (ObjectAdapter)iterator.next() : null;
    }

    public int size(ObjectAdapter collection) {
        return this.collectionOfUnderlying(collection).size();
    }

    public void init(ObjectAdapter collection, ObjectAdapter[] initData) {
        Collection<?> javaCollection = this.collectionOfUnderlying(collection);
        javaCollection.clear();
        for (ObjectAdapter element : initData) {
            javaCollection.add(element.getObject());
        }
    }

    private Collection<?> collectionOfUnderlying(ObjectAdapter wrappedCollection) {
        return (Collection)wrappedCollection.getObject();
    }

    private AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

