/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.collections.typeof;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.isis.applib.annotation.TypeOf;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.AnnotationBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetInferredFromArray;
import org.apache.isis.core.metamodel.facets.typeof.TypeOfFacetInferredFromGenerics;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.apache.isis.core.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistryAware;
import org.apache.isis.core.progmodel.facets.collections.typeof.TypeOfFacetAnnotationForCollection;

public class TypeOfAnnotationForCollectionsFacetFactory
extends AnnotationBasedFacetFactoryAbstract
implements CollectionTypeRegistryAware {
    private CollectionTypeRegistry collectionTypeRegistry;

    public TypeOfAnnotationForCollectionsFacetFactory() {
        super(FeatureType.COLLECTIONS_ONLY);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        TypeOf annotation = (TypeOf)TypeOfAnnotationForCollectionsFacetFactory.getAnnotation((Method)processMethodContext.getMethod(), TypeOf.class);
        Class<?> methodReturnType = processMethodContext.getMethod().getReturnType();
        if (!this.collectionTypeRegistry.isCollectionType(methodReturnType) && !this.collectionTypeRegistry.isArrayType(methodReturnType)) {
            return;
        }
        Class<?> returnType = processMethodContext.getMethod().getReturnType();
        if (returnType.isArray()) {
            Class<?> componentType = returnType.getComponentType();
            FacetUtil.addFacet((Facet)new TypeOfFacetInferredFromArray(componentType, processMethodContext.getFacetHolder(), this.getSpecificationLookup()));
            return;
        }
        if (annotation != null) {
            FacetUtil.addFacet((Facet)new TypeOfFacetAnnotationForCollection(annotation.value(), processMethodContext.getFacetHolder(), this.getSpecificationLookup()));
            return;
        }
        Type type = processMethodContext.getMethod().getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return;
        }
        Type actualTypeArgument = actualTypeArguments[0];
        if (actualTypeArgument instanceof Class) {
            Class actualType = (Class)actualTypeArgument;
            FacetUtil.addFacet((Facet)new TypeOfFacetInferredFromGenerics(actualType, processMethodContext.getFacetHolder(), this.getSpecificationLookup()));
            return;
        }
        if (actualTypeArgument instanceof TypeVariable) {
            return;
        }
    }

    public void setCollectionTypeRegistry(CollectionTypeRegistry collectionTypeRegistry) {
        this.collectionTypeRegistry = collectionTypeRegistry;
    }
}

