/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.disable.method;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.disable.method.DisableForContextFacetViaMethod;

public class DisabledFacetViaDisableMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterMapAware {
    private static final String[] PREFIXES = new String[]{"disable"};
    private AdapterMap adapterMap;

    public DisabledFacetViaDisableMethodFacetFactory() {
        super(FeatureType.MEMBERS, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        DisabledFacetViaDisableMethodFacetFactory.attachDisabledFacetIfDisabledMethodIsFound(processMethodContext);
    }

    public static void attachDisabledFacetIfDisabledMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = NameUtils.javaBaseNameStripAccessorPrefixIfRequired((String)method.getName());
        Class cls = processMethodContext.getCls();
        Method disableMethod = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "disable" + capitalizedName, String.class, new Class[0]);
        if (disableMethod == null) {
            return;
        }
        processMethodContext.removeMethod(disableMethod);
        FacetHolder facetHolder = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new DisableForContextFacetViaMethod(disableMethod, facetHolder));
    }

    public void setAdapterMap(AdapterMap adapterMap) {
        this.adapterMap = adapterMap;
    }
}

