/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.members.hide.forsession;

import java.lang.reflect.Method;
import org.apache.isis.applib.security.UserMemento;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.hide.forsession.HideForSessionFacetViaMethod;

public class HiddenFacetViaHideForSessionMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"hide"};

    public HiddenFacetViaHideForSessionMethodFacetFactory() {
        super(FeatureType.MEMBERS, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        HiddenFacetViaHideForSessionMethodFacetFactory.attachHideFacetIfHideMethodForSessionIsFound(processMethodContext);
    }

    public static void attachHideFacetIfHideMethodForSessionIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        String capitalizedName = NameUtils.javaBaseNameStripAccessorPrefixIfRequired((String)method.getName());
        Class cls = processMethodContext.getCls();
        Method hideForSessionMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "hide" + capitalizedName, Boolean.TYPE, new Class[]{UserMemento.class});
        if (hideForSessionMethod == null) {
            return;
        }
        processMethodContext.removeMethod(hideForSessionMethod);
        FacetHolder facetedMethod = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new HideForSessionFacetViaMethod(hideForSessionMethod, facetedMethod));
    }
}

