/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.facets;

import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.facets.FacetsFacet;

public abstract class FacetsFacetAbstract
extends FacetAbstract
implements FacetsFacet {
    private final Class<? extends FacetFactory>[] facetFactories;

    public static Class<? extends Facet> type() {
        return FacetsFacet.class;
    }

    public FacetsFacetAbstract(String[] names, Class<?>[] classes, FacetHolder holder) {
        super(FacetsFacetAbstract.type(), holder, false);
        Class<? extends FacetFactory> facetFactory;
        ArrayList<Class<? extends FacetFactory>> facetFactories = new ArrayList<Class<? extends FacetFactory>>();
        for (String name : names) {
            facetFactory = this.facetFactoryOrNull(name);
            if (facetFactory == null) continue;
            facetFactories.add(facetFactory);
        }
        for (Class<?> classe : classes) {
            facetFactory = this.facetFactoryOrNull(classe);
            if (facetFactory == null) continue;
            facetFactories.add(facetFactory);
        }
        this.facetFactories = this.asArray(facetFactories);
    }

    private Class<? extends FacetFactory>[] asArray(List<Class<? extends FacetFactory>> facetFactories) {
        return facetFactories.toArray(new Class[0]);
    }

    public Class<? extends FacetFactory>[] facetFactories() {
        return this.facetFactories;
    }

    private Class<? extends FacetFactory> facetFactoryOrNull(String classCandidateName) {
        if (classCandidateName == null) {
            return null;
        }
        Class classCandidate = null;
        try {
            classCandidate = InstanceUtil.loadClass((String)classCandidateName);
            return this.facetFactoryOrNull(classCandidate);
        }
        catch (IsisException ex) {
            return null;
        }
    }

    private Class<? extends FacetFactory> facetFactoryOrNull(Class classCandidate) {
        if (classCandidate == null) {
            return null;
        }
        return FacetFactory.class.isAssignableFrom(classCandidate) ? classCandidate : null;
    }
}

