/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.parseable;

import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;

public final class ParserUtil {
    public static final String PARSER_NAME_KEY_PREFIX = "isis.reflector.java.facets.parser.";
    public static final String PARSER_NAME_KEY_SUFFIX = ".parserName";

    private ParserUtil() {
    }

    static String parserNameFromConfiguration(Class<?> type, IsisConfiguration configuration) {
        String key = PARSER_NAME_KEY_PREFIX + type.getCanonicalName() + PARSER_NAME_KEY_SUFFIX;
        String parserName = configuration.getString(key);
        return !StringUtils.isNullOrEmpty((String)parserName) ? parserName : null;
    }

    public static Class<? extends Parser<?>> parserOrNull(Class<?> candidateClass, String classCandidateName) {
        Class type = candidateClass != null ? JavaClassUtils.implementingClassOrNull((String)candidateClass.getName(), Parser.class, FacetHolder.class) : null;
        return type != null ? type : JavaClassUtils.implementingClassOrNull((String)classCandidateName, Parser.class, FacetHolder.class);
    }
}

