/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.object.title;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.object.title.TitleFacetViaTitleMethod;
import org.apache.isis.core.progmodel.facets.object.title.TitleFacetViaToStringMethod;

public class TitleMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String TO_STRING = "toString";
    private static final String TITLE = "title";
    private static final String[] PREFIXES = new String[]{"toString", "title"};

    public TitleMethodFacetFactory() {
        super(FeatureType.OBJECTS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Class cls = processClassContext.getCls();
        FacetHolder facetHolder = processClassContext.getFacetHolder();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, TITLE, String.class, null);
        if (method != null) {
            processClassContext.removeMethod(method);
            FacetUtil.addFacet((Facet)new TitleFacetViaTitleMethod(method, facetHolder));
            return;
        }
        try {
            method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, TO_STRING, String.class, null);
            if (method == null) {
                return;
            }
            if (JavaClassUtils.isJavaClass(method.getDeclaringClass())) {
                return;
            }
            processClassContext.removeMethod(method);
            FacetUtil.addFacet((Facet)new TitleFacetViaToStringMethod(method, facetHolder));
        }
        catch (Exception e) {
            return;
        }
    }
}

