/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.choices.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.lang.ArrayUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.actions.choices.ActionChoicesFacetAbstract;
import org.apache.isis.core.metamodel.spec.DomainModelException;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;
import org.apache.isis.core.progmodel.facets.CollectionUtils;

public class ActionChoicesFacetViaMethod
extends ActionChoicesFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesType;
    private final SpecificationLookup specificationLookup;
    private final AdapterMap adapterMap;

    public ActionChoicesFacetViaMethod(Method method, Class<?> choicesType, FacetHolder holder, SpecificationLookup specificationLookup, AdapterMap adapterManager) {
        super(holder);
        this.method = method;
        this.choicesType = choicesType;
        this.specificationLookup = specificationLookup;
        this.adapterMap = adapterManager;
    }

    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    public boolean impliesResolve() {
        return true;
    }

    public boolean impliesObjectChanged() {
        return false;
    }

    public Object[][] getChoices(ObjectAdapter owningAdapter) {
        Object invoke = AdapterInvokeUtils.invoke((Method)this.method, (ObjectAdapter)owningAdapter);
        if (!(invoke instanceof Object[])) {
            throw new DomainModelException("Expected an array of collections (Object[]) containing choices for all parameters, but got " + invoke + " instead. Perhaps the parameter number is missing!");
        }
        Object[] options = (Object[])invoke;
        Object[][] results = new Object[options.length][];
        for (int i = 0; i < results.length; ++i) {
            if (options[i] == null) {
                results[i] = null;
                continue;
            }
            if (options[i].getClass().isArray()) {
                results[i] = ArrayUtil.getObjectAsObjectArray((Object)options[i]);
                continue;
            }
            ObjectSpecification specification = this.getSpecificationLookup().loadSpecification(this.choicesType);
            results[i] = CollectionUtils.getCollectionAsObjectArray(options[i], specification, this.getAdapterMap());
        }
        return results;
    }

    protected String toStringValues() {
        return "method=" + this.method + ",type=" + this.choicesType;
    }

    private SpecificationLookup getSpecificationLookup() {
        return this.specificationLookup;
    }

    private AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

