/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.param.named.staticmethod;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.adapter.util.InvokeUtils;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.members.named.staticmethod.NamedFacetViaMethod;

public class ActionParameterNamesMethodFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterMapAware {
    private static final String[] PREFIXES = new String[]{"name"};
    private AdapterMap adapterMap;

    public ActionParameterNamesMethodFacetFactory() {
        super(FeatureType.ACTIONS_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        List holderList = facetedMethod.getParameters();
        ActionParameterNamesMethodFacetFactory.attachNamedFacetForParametersIfParameterNamesMethodIsFound(processMethodContext, holderList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void attachNamedFacetForParametersIfParameterNamesMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext, List<FacetedMethodParameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        Method actionMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.capitalizeName((String)actionMethod.getName());
        Class cls = processMethodContext.getCls();
        Method namesMethod = MethodFinderUtils.findMethod(cls, MethodScope.CLASS, "name" + capitalizedName, String[].class, new Class[0]);
        if (namesMethod == null) {
            return;
        }
        try {
            String[] names = ActionParameterNamesMethodFacetFactory.invokeNamesMethod(namesMethod, parameters.size());
            for (int i = 0; i < names.length; ++i) {
                FacetUtil.addFacet((Facet)new NamedFacetViaMethod(names[i], namesMethod, (FacetHolder)parameters.get(i)));
            }
        }
        finally {
            processMethodContext.removeMethod(namesMethod);
        }
    }

    private static String[] invokeNamesMethod(Method namesMethod, int numElementsRequired) {
        String[] names = null;
        try {
            names = (String[])InvokeUtils.invokeStatic((Method)namesMethod, (Object[])new Object[0]);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (names == null || names.length != numElementsRequired) {
            throw new MetaModelException(namesMethod + " must return an String[] array of same size as number of parameters of action");
        }
        return names;
    }

    public void setAdapterMap(AdapterMap adapterMap) {
        this.adapterMap = adapterMap;
    }

    private AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

