/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.choices.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.lang.ArrayUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.util.AdapterInvokeUtils;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLookup;
import org.apache.isis.core.progmodel.facets.CollectionUtils;
import org.apache.isis.core.progmodel.facets.properties.choices.PropertyChoicesFacetAbstract;

public class PropertyChoicesFacetViaMethod
extends PropertyChoicesFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesClass;
    private final AdapterMap adapterMap;

    public PropertyChoicesFacetViaMethod(Method method, Class<?> choicesClass, FacetHolder holder, SpecificationLookup specificationLookup, AdapterMap adapterManager) {
        super(holder, specificationLookup);
        this.method = method;
        this.choicesClass = choicesClass;
        this.adapterMap = adapterManager;
    }

    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    public boolean impliesResolve() {
        return true;
    }

    public boolean impliesObjectChanged() {
        return false;
    }

    public Object[] getChoices(ObjectAdapter owningAdapter, SpecificationLookup specificationLookup) {
        Object options = AdapterInvokeUtils.invoke((Method)this.method, (ObjectAdapter)owningAdapter);
        if (options == null) {
            return null;
        }
        if (options.getClass().isArray()) {
            return ArrayUtil.getObjectAsObjectArray((Object)options);
        }
        ObjectSpecification specification = specificationLookup.loadSpecification(this.choicesClass);
        return CollectionUtils.getCollectionAsObjectArray(options, specification, this.getAdapterMap());
    }

    protected String toStringValues() {
        return "method=" + this.method + ",class=" + this.choicesClass;
    }

    protected AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

