/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.properties.defaults.method;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.NameUtils;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.adapter.map.AdapterMapAware;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.progmodel.facets.MethodFinderUtils;
import org.apache.isis.core.progmodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.progmodel.facets.properties.defaults.method.PropertyDefaultFacetViaMethod;

public class PropertyDefaultFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements AdapterMapAware {
    private static final String[] PREFIXES = new String[]{"default"};
    private AdapterMap adapterMap;

    public PropertyDefaultFacetFactory() {
        super(FeatureType.PROPERTIES_ONLY, PREFIXES);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachPropertyDefaultFacetIfDefaultMethodIsFound(processMethodContext);
    }

    private void attachPropertyDefaultFacetIfDefaultMethodIsFound(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = NameUtils.javaBaseName((String)getMethod.getName());
        Class cls = processMethodContext.getCls();
        Class<?> returnType = getMethod.getReturnType();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "default" + capitalizedName, returnType, NO_PARAMETERS_TYPES);
        if (method == null) {
            return;
        }
        processMethodContext.removeMethod(method);
        FacetHolder property = processMethodContext.getFacetHolder();
        FacetUtil.addFacet((Facet)new PropertyDefaultFacetViaMethod(method, property, this.getSpecificationLookup(), this.getAdapterMap()));
    }

    public void setAdapterMap(AdapterMap adapterManager) {
        this.adapterMap = adapterManager;
    }

    protected AdapterMap getAdapterMap() {
        return this.adapterMap;
    }
}

