/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.money;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.applib.value.Money;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.money.MoneyValueFacet;

public class MoneyValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<Money>
implements MoneyValueFacet {
    private static final NumberFormat DEFAULT_NUMBER_FORMAT;
    private static final NumberFormat DEFAULT_CURRENCY_FORMAT;
    private static final String LOCAL_CURRENCY_CODE;
    private static final int TYPICAL_LENGTH = 18;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private static final Money DEFAULT_VALUE;
    private final String defaultCurrencyCode;

    private static Class<? extends Facet> type() {
        return MoneyValueFacet.class;
    }

    static final boolean isAPropertyDefaultFacet() {
        return PropertyDefaultFacet.class.isAssignableFrom(MoneyValueSemanticsProvider.class);
    }

    private static String getDefaultCurrencyCode() {
        try {
            return DEFAULT_CURRENCY_FORMAT.getCurrency().getCurrencyCode();
        }
        catch (UnsupportedOperationException e) {
            return "";
        }
    }

    public MoneyValueSemanticsProvider() {
        this(null, null, null);
    }

    public MoneyValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(MoneyValueSemanticsProvider.type(), holder, Money.class, 18, true, true, DEFAULT_VALUE, configuration, context);
        String property = "isis.value.money.currency";
        this.defaultCurrencyCode = configuration.getString("isis.value.money.currency", LOCAL_CURRENCY_CODE);
    }

    @Override
    protected Money doParse(Object context, String text) {
        int pos;
        String entry = text.trim();
        if (this.endsWithCurrencyCode(entry, pos = entry.lastIndexOf(32))) {
            String value = entry.substring(0, pos);
            String code = entry.substring(pos + 1);
            return this.parseNumberAndCurrencyCode(value, code);
        }
        return this.parseDerivedValue(context, entry);
    }

    private boolean endsWithCurrencyCode(String entry, int pos) {
        String suffix = entry.substring(pos + 1);
        boolean isCurrencyCode = suffix.length() == 3 && Character.isLetter(suffix.charAt(0)) && Character.isLetter(suffix.charAt(1)) && Character.isLetter(suffix.charAt(2));
        return isCurrencyCode;
    }

    private Money parseDerivedValue(Object original, String entry) {
        Money money = (Money)original;
        if (money == null || money.getCurrency().equals(LOCAL_CURRENCY_CODE)) {
            try {
                double value = DEFAULT_CURRENCY_FORMAT.parse(entry).doubleValue();
                money = new Money(value, LOCAL_CURRENCY_CODE);
                return money;
            }
            catch (ParseException ignore) {
                // empty catch block
            }
        }
        try {
            double value = DEFAULT_NUMBER_FORMAT.parse(entry).doubleValue();
            String currencyCode = money == null ? this.defaultCurrencyCode : money.getCurrency();
            money = new Money(value, currencyCode);
            return money;
        }
        catch (ParseException ex) {
            throw new TextEntryParseException("Not a distinguishable money value " + entry, (Throwable)ex);
        }
    }

    private Money parseNumberAndCurrencyCode(String amount, String code) {
        String currencyCode = code.toUpperCase();
        try {
            Currency.getInstance(currencyCode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new TextEntryParseException("Invalid currency code " + currencyCode, (Throwable)e);
        }
        try {
            Money money = new Money(DEFAULT_NUMBER_FORMAT.parse(amount).doubleValue(), currencyCode);
            return money;
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Invalid money entry", (Throwable)e);
        }
    }

    @Override
    public String titleString(Object object, Localization localization) {
        if (object == null) {
            return "";
        }
        Money money = (Money)object;
        boolean localCurrency = LOCAL_CURRENCY_CODE.equals(money.getCurrency());
        if (localCurrency) {
            return DEFAULT_CURRENCY_FORMAT.format(money.doubleValue());
        }
        return DEFAULT_NUMBER_FORMAT.format(money.doubleValue()) + " " + money.getCurrency();
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        if (value == null) {
            return "";
        }
        Money money = (Money)value;
        return new DecimalFormat(usingMask).format(money.doubleValue());
    }

    @Override
    protected String doEncode(Object object) {
        Money money = (Money)object;
        String value = String.valueOf(money.doubleValue()) + " " + money.getCurrency();
        return value;
    }

    @Override
    protected Money doRestore(String data) {
        String dataString = data;
        int pos = dataString.indexOf(32);
        String amount = dataString.substring(0, pos);
        String currency = dataString.substring(pos + 1);
        return new Money(Double.valueOf(amount).doubleValue(), currency);
    }

    @Override
    public float getAmount(ObjectAdapter object) {
        Money money = (Money)object.getObject();
        if (money == null) {
            return 0.0f;
        }
        return money.floatValue();
    }

    @Override
    public String getCurrencyCode(ObjectAdapter object) {
        Money money = (Money)object.getObject();
        if (money == null) {
            return "";
        }
        return money.getCurrency();
    }

    @Override
    public ObjectAdapter createValue(float amount, String currencyCode) {
        return this.getAdapterMap().adapterFor((Object)new Money((double)amount, currencyCode));
    }

    public String toString() {
        return "MoneyValueSemanticsProvider: " + MoneyValueSemanticsProvider.getDefaultCurrencyCode();
    }

    static {
        DEFAULT_VALUE = null;
        DEFAULT_NUMBER_FORMAT = NumberFormat.getNumberInstance();
        DEFAULT_CURRENCY_FORMAT = NumberFormat.getCurrencyInstance();
        DEFAULT_NUMBER_FORMAT.setMinimumFractionDigits(DEFAULT_CURRENCY_FORMAT.getMinimumFractionDigits());
        DEFAULT_NUMBER_FORMAT.setMaximumFractionDigits(DEFAULT_CURRENCY_FORMAT.getMaximumFractionDigits());
        LOCAL_CURRENCY_CODE = MoneyValueSemanticsProvider.getDefaultCurrencyCode();
    }
}

