/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.about;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.runtime.about.ComponentDetails;

public class AboutIsis {
    private static String applicationCopyrightNotice;
    private static String applicationName;
    private static String applicationVersion;
    private static String frameworkName;
    private static String frameworkVersion;
    private static String logo;
    private static String frameworkCopyright;
    private static String frameworkCompileDate;
    private static List<ComponentDetails> componentDetails;

    public static String findVersion() {
        try {
            String moduleId = "org.apache.isis.plugins:dndviewer";
            String module = moduleId.replace(":", "/");
            InputStream resourceAsStream = AboutIsis.class.getClassLoader().getResourceAsStream("META-INF/maven/" + module + "/pom.properties");
            if (resourceAsStream == null) {
                return "no version";
            }
            Properties p = new Properties();
            p.load(resourceAsStream);
            String version = p.getProperty("version");
            return version;
        }
        catch (IOException e) {
            throw new IsisException((Throwable)e);
        }
    }

    public static String getApplicationCopyrightNotice() {
        return applicationCopyrightNotice;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static String getApplicationVersion() {
        return applicationVersion;
    }

    public static String getFrameworkCopyrightNotice() {
        return AboutIsis.select(frameworkCopyright, "Copyright Apache Software Foundation");
    }

    public static String getFrameworkCompileDate() {
        return frameworkCompileDate;
    }

    public static String getFrameworkName() {
        return AboutIsis.select(frameworkName, "Apache Isis (incubating)");
    }

    public static String getImageName() {
        return AboutIsis.select(logo, "splash-logo");
    }

    public static String getFrameworkVersion() {
        String version = "Version " + AboutIsis.select(frameworkVersion, "unreleased");
        return version;
    }

    public static void main(String[] args) {
        System.out.println(AboutIsis.getFrameworkName() + ", " + AboutIsis.getFrameworkVersion());
        System.out.println(AboutIsis.getFrameworkCopyrightNotice());
    }

    private static String select(String value, String defaultValue) {
        return value == null || value.startsWith("${") ? defaultValue : value;
    }

    public static void setApplicationCopyrightNotice(String applicationCopyrightNotice) {
        AboutIsis.applicationCopyrightNotice = applicationCopyrightNotice;
    }

    public static void setApplicationName(String applicationName) {
        AboutIsis.applicationName = applicationName;
    }

    public static void setApplicationVersion(String applicationVersion) {
        AboutIsis.applicationVersion = applicationVersion;
    }

    public static void setComponentDetails(List<ComponentDetails> componentDetails) {
        AboutIsis.componentDetails = componentDetails;
    }

    static {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("isis-version");
            logo = bundle.getString("framework.logo");
            frameworkVersion = bundle.getString("framework.version");
            frameworkName = bundle.getString("framework.name");
            frameworkCopyright = bundle.getString("framework.copyright");
            frameworkCompileDate = bundle.getString("framework.compile.date");
        }
        catch (MissingResourceException ex) {
            logo = "splash-logo";
            frameworkVersion = "${project.version}-r${buildNumber}";
            frameworkCopyright = "Copyright (c) 2010~2011 Apache Software Foundation";
            frameworkName = "${project.parent.name}";
        }
    }
}

