/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.authentication.standard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.authentication.standard.Authenticator;
import org.apache.isis.core.runtime.authentication.standard.NoAuthenticatorException;
import org.apache.isis.core.runtime.authentication.standard.RandomCodeGenerator;
import org.apache.isis.core.runtime.authentication.standard.RandomCodeGenerator10Chars;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class AuthenticationManagerStandard
implements AuthenticationManager,
DebuggableWithTitle {
    private final Map<String, String> userByValidationCode = Maps.newHashMap();
    private List<Authenticator> authenticators = Lists.newArrayList();
    private RandomCodeGenerator randomCodeGenerator;
    private IsisConfiguration configuration;

    public AuthenticationManagerStandard(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    public final void init() {
        this.defaultRandomCodeGeneratorIfNecessary();
        this.addDefaultAuthenticators();
        if (this.authenticators.size() == 0) {
            throw new IsisException("No authenticators specified");
        }
        for (Authenticator authenticator : this.authenticators) {
            authenticator.init();
        }
    }

    private void defaultRandomCodeGeneratorIfNecessary() {
        if (this.randomCodeGenerator == null) {
            this.randomCodeGenerator = new RandomCodeGenerator10Chars();
        }
    }

    protected void addDefaultAuthenticators() {
    }

    public void shutdown() {
        for (Authenticator authenticator : this.authenticators) {
            authenticator.shutdown();
        }
    }

    @Override
    public final synchronized AuthenticationSession authenticate(AuthenticationRequest request) {
        if (request == null) {
            return null;
        }
        for (Authenticator authenticator : this.authenticators) {
            if (!authenticator.canAuthenticate(request)) continue;
            AuthenticationSession authSession = null;
            authSession = authenticator.authenticate(request, this.getUnusedRandomCode());
            if (authSession != null) {
                this.userByValidationCode.put(authSession.getValidationCode(), authSession.getUserName());
            }
            return authSession;
        }
        throw new NoAuthenticatorException("No authenticator available for processing " + request.getClass().getName());
    }

    private String getUnusedRandomCode() {
        String code;
        while (this.userByValidationCode.containsKey(code = this.randomCodeGenerator.generateRandomCode())) {
        }
        return code;
    }

    @Override
    public final boolean isSessionValid(AuthenticationSession session) {
        String userName = this.userByValidationCode.get(session.getValidationCode());
        return session.hasUserNameOf(userName);
    }

    @Override
    public void closeSession(AuthenticationSession session) {
        this.userByValidationCode.remove(session.getValidationCode());
    }

    public final void addAuthenticator(Authenticator authenticator) {
        this.authenticators.add(authenticator);
    }

    protected void addAuthenticatorToStart(Authenticator authenticator) {
        this.authenticators.add(0, authenticator);
    }

    public void setAuthenticators(List<Authenticator> authenticators) {
        this.authenticators = authenticators;
    }

    public List<Authenticator> getAuthenticators() {
        return Collections.unmodifiableList(this.authenticators);
    }

    public RandomCodeGenerator getRandomCodeGenerator() {
        return this.randomCodeGenerator;
    }

    public void setRandomCodeGenerator(RandomCodeGenerator randomCodeGenerator) {
        Ensure.ensureThatArg((Object)randomCodeGenerator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"randomCodeGenerator cannot be null");
        this.randomCodeGenerator = randomCodeGenerator;
    }

    public String debugTitle() {
        return "Authentication Manager";
    }

    public void debugData(DebugBuilder debug) {
        debug.appendTitle("Authenticators");
        debug.indent();
        for (Authenticator authenticator : this.authenticators) {
            debug.appendln(authenticator.toString());
        }
        debug.unindent();
        debug.appendTitle("Users");
        debug.indent();
        for (String userName : this.userByValidationCode.values()) {
            debug.appendln(userName);
        }
        debug.unindent();
    }

    public String toString() {
        ToString str = ToString.createAnonymous((Object)this);
        str.append("authenticators", this.authenticators.size());
        str.append("users", this.userByValidationCode.size());
        return str.toString();
    }

    protected IsisConfiguration getConfiguration() {
        return this.configuration;
    }
}

