/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.authentication.standard;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.authentication.RegistrationDetails;
import org.apache.isis.core.runtime.authentication.standard.Authenticator;
import org.apache.isis.core.runtime.authentication.standard.AuthenticatorFuncs;
import org.apache.isis.core.runtime.authentication.standard.NoAuthenticatorException;
import org.apache.isis.core.runtime.authentication.standard.RandomCodeGenerator;
import org.apache.isis.core.runtime.authentication.standard.RandomCodeGenerator10Chars;
import org.apache.isis.core.runtime.authentication.standard.Registrar;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class AuthenticationManagerStandard
implements AuthenticationManager,
DebuggableWithTitle {
    private final Map<String, String> userByValidationCode = Maps.newHashMap();
    private List<Authenticator> authenticators = Lists.newArrayList();
    private RandomCodeGenerator randomCodeGenerator;
    private final IsisConfiguration configuration;

    public AuthenticationManagerStandard(IsisConfiguration configuration) {
        this.configuration = configuration;
    }

    public final void init() {
        this.defaultRandomCodeGeneratorIfNecessary();
        this.addDefaultAuthenticators();
        if (this.authenticators.size() == 0) {
            throw new IsisException("No authenticators specified");
        }
        for (Authenticator authenticator : this.authenticators) {
            authenticator.init();
        }
    }

    private void defaultRandomCodeGeneratorIfNecessary() {
        if (this.randomCodeGenerator == null) {
            this.randomCodeGenerator = new RandomCodeGenerator10Chars();
        }
    }

    protected void addDefaultAuthenticators() {
    }

    public void shutdown() {
        for (Authenticator authenticator : this.authenticators) {
            authenticator.shutdown();
        }
    }

    @Override
    public final synchronized AuthenticationSession authenticate(AuthenticationRequest request) {
        if (request == null) {
            return null;
        }
        Collection compatibleAuthenticators = Collections2.filter(this.authenticators, AuthenticatorFuncs.compatibleWith(request));
        if (compatibleAuthenticators.size() == 0) {
            throw new NoAuthenticatorException("No authenticator available for processing " + request.getClass().getName());
        }
        for (Authenticator authenticator : compatibleAuthenticators) {
            AuthenticationSession authSession = authenticator.authenticate(request, this.getUnusedRandomCode());
            if (authSession == null) continue;
            this.userByValidationCode.put(authSession.getValidationCode(), authSession.getUserName());
            return authSession;
        }
        return null;
    }

    private String getUnusedRandomCode() {
        String code;
        while (this.userByValidationCode.containsKey(code = this.randomCodeGenerator.generateRandomCode())) {
        }
        return code;
    }

    @Override
    public final boolean isSessionValid(AuthenticationSession session) {
        String userName = this.userByValidationCode.get(session.getValidationCode());
        return session.hasUserNameOf(userName);
    }

    @Override
    public void closeSession(AuthenticationSession session) {
        this.userByValidationCode.remove(session.getValidationCode());
    }

    public final void addAuthenticator(Authenticator authenticator) {
        this.authenticators.add(authenticator);
    }

    protected void addAuthenticatorToStart(Authenticator authenticator) {
        this.authenticators.add(0, authenticator);
    }

    public void setAuthenticators(List<Authenticator> authenticators) {
        this.authenticators = authenticators;
    }

    public List<Authenticator> getAuthenticators() {
        return Collections.unmodifiableList(this.authenticators);
    }

    @Override
    public boolean register(RegistrationDetails registrationDetails) {
        for (Registrar registrar : this.getRegistrars()) {
            if (!registrar.canRegister(registrationDetails.getClass())) continue;
            return registrar.register(registrationDetails);
        }
        return false;
    }

    @Override
    public boolean supportsRegistration(Class<? extends RegistrationDetails> registrationDetailsClass) {
        for (Registrar registrar : this.getRegistrars()) {
            if (!registrar.canRegister(registrationDetailsClass)) continue;
            return true;
        }
        return false;
    }

    public List<Registrar> getRegistrars() {
        return AuthenticationManagerStandard.asAuthenticators(this.getAuthenticators());
    }

    private static List<Registrar> asAuthenticators(List<Authenticator> authenticators2) {
        List registrars = Lists.transform(authenticators2, Registrar.AS_REGISTRAR_ELSE_NULL);
        return Lists.newArrayList((Iterable)Collections2.filter((Collection)registrars, Registrar.NON_NULL));
    }

    public RandomCodeGenerator getRandomCodeGenerator() {
        return this.randomCodeGenerator;
    }

    public void setRandomCodeGenerator(RandomCodeGenerator randomCodeGenerator) {
        Ensure.ensureThatArg((Object)randomCodeGenerator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"randomCodeGenerator cannot be null");
        this.randomCodeGenerator = randomCodeGenerator;
    }

    public String debugTitle() {
        return "Authentication Manager";
    }

    public void debugData(DebugBuilder debug) {
        debug.appendTitle("Authenticators");
        debug.indent();
        for (Authenticator authenticator : this.authenticators) {
            debug.appendln(authenticator.toString());
        }
        debug.unindent();
        debug.appendTitle("Users");
        debug.indent();
        for (String userName : this.userByValidationCode.values()) {
            debug.appendln(userName);
        }
        debug.unindent();
    }

    public String toString() {
        ToString str = ToString.createAnonymous((Object)this);
        str.append("authenticators", this.authenticators.size());
        str.append("users", this.userByValidationCode.size());
        return str.toString();
    }

    protected IsisConfiguration getConfiguration() {
        return this.configuration;
    }
}

