/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.authorization.standard;

import org.apache.isis.applib.Identifier;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.authorization.AuthorizationManagerAbstract;
import org.apache.isis.core.runtime.authorization.standard.Authorizor;

public class AuthorizationManagerStandard
extends AuthorizationManagerAbstract {
    private Authorizor authorizor = new Authorizor(){

        public void init() {
        }

        public void shutdown() {
        }

        @Override
        public boolean isVisibleInRole(String user, Identifier identifier) {
            return true;
        }

        @Override
        public boolean isUsableInRole(String role, Identifier identifier) {
            return true;
        }
    };

    public AuthorizationManagerStandard(IsisConfiguration configuration) {
        super(configuration);
    }

    public void init() {
        this.authorizor.init();
    }

    public void shutdown() {
        this.authorizor.shutdown();
    }

    @Override
    public boolean isUsable(AuthenticationSession session, ObjectAdapter target, Identifier identifier) {
        if (this.isPerspectiveMember(identifier)) {
            return true;
        }
        for (String roleName : session.getRoles()) {
            if (!this.authorizor.isUsableInRole(roleName, identifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible(AuthenticationSession session, ObjectAdapter target, Identifier identifier) {
        if (this.isPerspectiveMember(identifier)) {
            return true;
        }
        for (String roleName : session.getRoles()) {
            if (!this.authorizor.isVisibleInRole(roleName, identifier)) continue;
            return true;
        }
        return false;
    }

    private boolean isPerspectiveMember(Identifier identifier) {
        return identifier.getClassName().equals("");
    }

    protected void setAuthorizor(Authorizor authorisor) {
        this.authorizor = authorisor;
    }
}

