/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.logging;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.isis.core.commons.lang.IoUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;

public class IsisLoggingConfigurer {
    private boolean loggingSetup;

    public void configureLogging(String configDirectory, String[] args) {
        if (this.loggingSetup) {
            return;
        }
        this.loggingSetup = true;
        IsisLoggingConfigurer.configureLogging(configDirectory);
        IsisLoggingConfigurer.applyLoggingLevelFromCommandLine(args);
    }

    private static void applyLoggingLevelFromCommandLine(String[] args) {
        Level loggingLevel = IsisLoggingConfigurer.loggingLevel(args);
        if (loggingLevel != null) {
            Logger.getRootLogger().setLevel(loggingLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void configureLogging(String configDirectory) {
        Properties properties = new Properties();
        String path = configDirectory + "/" + "logging.properties";
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(path);
            properties.load(inStream);
        }
        catch (IOException ignore) {
            IoUtils.closeSafely((Closeable)inStream);
            catch (Throwable throwable) {
                IoUtils.closeSafely(inStream);
                throw throwable;
            }
        }
        IoUtils.closeSafely((Closeable)inStream);
        if (properties.size() == 0) {
            InputStream inStream2;
            block11: {
                inStream2 = null;
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    inStream2 = classLoader.getResourceAsStream(path);
                    if (inStream2 == null) break block11;
                    properties.load(inStream2);
                }
                catch (IOException ignore) {
                    IoUtils.closeSafely(inStream2);
                    catch (Throwable throwable) {
                        IoUtils.closeSafely(inStream2);
                        throw throwable;
                    }
                }
            }
            IoUtils.closeSafely((Closeable)inStream2);
        }
        if (properties.size() > 0) {
            PropertyConfigurator.configure((Properties)properties);
        } else {
            IsisLoggingConfigurer.configureFallbackLogging();
        }
    }

    private static void configureFallbackLogging() {
        PatternLayout layout = new PatternLayout("%-5r [%-25.25c{1} %-10.10t %-5.5p]  %m%n");
        ConsoleAppender appender = new ConsoleAppender((Layout)layout);
        BasicConfigurator.configure((Appender)appender);
        Logger.getRootLogger().setLevel(Level.WARN);
        Logger.getLogger((String)"ui").setLevel(Level.OFF);
    }

    private static Level loggingLevel(String[] args) {
        Level level = null;
        for (String arg : args) {
            if (arg.equals("-debug")) {
                level = Level.DEBUG;
                break;
            }
            if (arg.equals("-quiet")) {
                level = Level.ERROR;
                break;
            }
            if (!arg.equals("-verbose")) continue;
            level = Level.INFO;
            break;
        }
        return level;
    }
}

