/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public abstract class Logger {
    public static final String PROPERTY_ROOT = "isis.logging.";
    private org.apache.log4j.Logger logger;
    private final Level level;

    public Logger() {
        this(Level.DEBUG);
    }

    public Logger(String level) {
        this.level = Level.toLevel((String)level);
    }

    public Logger(Level level) {
        this.level = level;
    }

    protected abstract Class<?> getDecoratedClass();

    public void log(String message) {
        this.logger().log((Priority)this.level, (Object)message);
    }

    public void log(String request, Object result) {
        this.log(request + "  -> " + result);
    }

    private org.apache.log4j.Logger logger() {
        if (this.logger == null) {
            this.logger = org.apache.log4j.Logger.getLogger(this.getDecoratedClass());
        }
        return this.logger;
    }
}

