/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.sysout;

import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.IoUtils;
import org.apache.isis.core.runtime.about.AboutIsis;

public class SystemPrinter {
    private final PrintStream output;

    public SystemPrinter() {
        this(System.out);
    }

    public SystemPrinter(PrintStream output) {
        this.output = output;
    }

    protected PrintStream getOutput() {
        return this.output;
    }

    void print(String string) {
        this.output.println(string);
    }

    void printBlock(String title) {
        this.print("");
        this.print("------------------------------------------");
        this.print(title);
        this.print("------------------------------------------");
    }

    public void printDiagnostics() {
        block12: {
            String[] files;
            this.print("------- Apache Isis diagnostics report -------");
            this.printVersion();
            this.printBlock("System properties");
            Properties properties = System.getProperties();
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                String property = properties.getProperty(name);
                StringBuilder buf = new StringBuilder();
                if (name.endsWith(".path") || name.endsWith(".dirs")) {
                    String[] split = property.split(":");
                    buf.append(split[0]);
                    for (int i = 1; i < split.length; ++i) {
                        buf.append("\n\t\t" + split[i]);
                    }
                }
                this.print(name + "= " + buf.toString());
            }
            File file = new File("../lib");
            if (file.isDirectory()) {
                files = file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
                this.printBlock("Libs");
                for (String file2 : files) {
                    this.print(file2);
                }
            }
            this.printBlock("Locale information");
            this.print("Default locale: " + Locale.getDefault());
            this.print("Default timezone: " + TimeZone.getDefault());
            file = new File("config");
            if (!file.isDirectory()) break block12;
            files = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return new File(dir, name).isFile();
                }
            });
            this.printBlock("Config files");
            for (String file2 : files) {
                this.print(file2);
            }
            for (String file2 : files) {
                this.print("");
                this.print("--------------------------------------------------------------------------------------------------------");
                this.print(file2);
                this.print("");
                LineNumberReader fileInputStream = null;
                try {
                    String line;
                    fileInputStream = new LineNumberReader(new FileReader(new File(file, file2)));
                    while ((line = fileInputStream.readLine()) != null) {
                        this.print(fileInputStream.getLineNumber() + "  " + line);
                    }
                }
                catch (Exception e) {
                    try {
                        throw new IsisException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeSafely(fileInputStream);
                        throw throwable;
                    }
                }
                IoUtils.closeSafely((Closeable)fileInputStream);
                this.print("");
            }
        }
    }

    public void printVersion() {
        String date = AboutIsis.getFrameworkCompileDate();
        String compileDate = date == null ? "" : ", compiled on " + date;
        this.print(AboutIsis.getFrameworkName() + ", " + AboutIsis.getFrameworkVersion() + compileDate);
    }

    public void printErrorMessage(String message) {
        this.output.println("Error: " + message);
    }
}

