/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.userprofile;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;

public class PerspectiveEntry {
    private String name;
    private final List<Object> objects = Lists.newArrayList();
    private final List<Object> services = Lists.newArrayList();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.name + " (" + this.services.size() + " classes)";
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    public void addToObjects(Object obj) {
        if (!this.objects.contains(obj)) {
            this.objects.add(obj);
        }
    }

    public void removeFromObjects(Object obj) {
        this.objects.remove(obj);
    }

    public void save(List<ObjectAdapter> adapters) {
        this.objects.clear();
        for (ObjectAdapter adapter : adapters) {
            this.addToObjects(adapter.getObject());
        }
    }

    public List<Object> getServices() {
        return this.services;
    }

    public void addToServices(Object service) {
        if (service != null && !this.services.contains(service)) {
            this.services.add(service);
        }
    }

    public void removeFromServices(Object service) {
        if (service != null && this.services.contains(service)) {
            this.services.remove(service);
        }
    }

    public void copy(PerspectiveEntry template) {
        this.name = template.getName();
        for (Object service : template.getServices()) {
            this.addToServices(service);
        }
        for (Object obj : template.getObjects()) {
            this.addToObjects(obj);
        }
    }
}

