/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.userprofile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.userprofile.Options;
import org.apache.isis.core.runtime.userprofile.PerspectiveEntry;

public class UserProfile {
    private PerspectiveEntry entry;
    private final List<PerspectiveEntry> entries = Lists.newArrayList();
    private final Options options = new Options();
    private Localization localization;

    public PerspectiveEntry getPerspective() {
        if (this.entry == null) {
            if (this.entries.size() == 0) {
                throw new IsisException("No perspective in user profile");
            }
            this.entry = this.entries.get(0);
        }
        return this.entry;
    }

    public PerspectiveEntry newPerspective(String name) {
        this.entry = new PerspectiveEntry();
        this.entry.setName(name);
        this.entries.add(this.entry);
        return this.entry;
    }

    public void removeCurrent() {
        if (this.entries.size() > 1) {
            this.entries.remove(this.entry);
            this.entry = this.entries.get(0);
        }
    }

    public PerspectiveEntry getPerspective(String name) {
        for (PerspectiveEntry entry : this.entries) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        throw new IsisException("No perspective " + name);
    }

    public void addToPerspectives(PerspectiveEntry perspective) {
        PerspectiveEntry e = new PerspectiveEntry();
        e.copy(perspective);
        this.entries.add(e);
    }

    public List<String> list() {
        ArrayList list = Lists.newArrayList();
        for (PerspectiveEntry entry : this.entries) {
            list.add(entry.getName());
        }
        return list;
    }

    public void select(String name) {
        for (PerspectiveEntry entry : this.entries) {
            if (!entry.getName().equals(name)) continue;
            this.entry = entry;
            break;
        }
    }

    public void copy(UserProfile template) {
        for (PerspectiveEntry entry : template.entries) {
            PerspectiveEntry e = new PerspectiveEntry();
            e.copy(entry);
            this.entries.add(e);
        }
        this.options.copy(template.getOptions());
    }

    public List<PerspectiveEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public Options getOptions() {
        return this.options;
    }

    public void addToOptions(String name, String value) {
        this.options.addOption(name, value);
    }

    public Localization getLocalization() {
        return this.localization;
    }

    public void setLocalization(Localization localization) {
        this.localization = localization;
    }

    public void saveObjects(List<ObjectAdapter> objects) {
        this.entry.save(objects);
    }
}

