/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.bytecode.dflt.objectfactory.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.isis.core.commons.lang.ArrayUtils;
import org.apache.isis.core.metamodel.facets.ImperativeFacetUtils;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.metamodel.specloader.specimpl.dflt.ObjectSpecificationDefault;
import org.apache.isis.runtimes.dflt.bytecode.dflt.objectfactory.internal.CglibEnhanced;
import org.apache.isis.runtimes.dflt.runtime.bytecode.ObjectResolveAndObjectChangedEnhancerAbstract;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectfactory.ObjectChanger;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectfactory.ObjectResolver;

public class ObjectResolveAndObjectChangedEnhancer
extends ObjectResolveAndObjectChangedEnhancerAbstract {
    private Callback callback;
    private final Map<Class<?>, Enhancer> enhancerByClass = new HashMap();

    public ObjectResolveAndObjectChangedEnhancer(ObjectResolver objectResolver, ObjectChanger objectChanger, SpecificationLoader specificationLoader) {
        super(objectResolver, objectChanger, specificationLoader);
        this.createCallback();
    }

    protected void createCallback() {
        this.callback = new MethodInterceptor(){

            public Object intercept(Object proxied, Method proxiedMethod, Object[] args, MethodProxy proxyMethod) throws Throwable {
                ObjectSpecificationDefault targetObjSpec;
                ObjectMember member;
                boolean ignore = proxiedMethod.getDeclaringClass().equals(Object.class);
                ImperativeFacetUtils.ImperativeFacetFlags flags = null;
                if (!ignore && (flags = ImperativeFacetUtils.getImperativeFacetFlags((ObjectMember)(member = (targetObjSpec = ObjectResolveAndObjectChangedEnhancer.this.getJavaSpecificationOfOwningClass(proxiedMethod)).getMember(proxiedMethod)), (Method)proxiedMethod)).impliesResolve()) {
                    ObjectResolveAndObjectChangedEnhancer.this.objectResolver.resolve(proxied, member.getName());
                }
                Object proxiedReturn = proxyMethod.invokeSuper(proxied, args);
                if (!ignore && flags.impliesObjectChanged()) {
                    ObjectResolveAndObjectChangedEnhancer.this.objectChanger.objectChanged(proxied);
                }
                return proxiedReturn;
            }
        };
    }

    public <T> T newInstance(Class<T> cls) {
        Enhancer enhancer = this.lookupOrCreateEnhancerFor(cls);
        return (T)enhancer.create();
    }

    private Enhancer lookupOrCreateEnhancerFor(Class<?> cls) {
        Enhancer enhancer = this.enhancerByClass.get(cls);
        if (enhancer == null) {
            enhancer = new Enhancer();
            enhancer.setSuperclass(cls);
            enhancer.setInterfaces((Class[])ArrayUtils.combine((Object[][])new Class[][]{cls.getInterfaces(), {CglibEnhanced.class}}));
            enhancer.setCallback(this.callback);
            this.enhancerByClass.put(cls, enhancer);
        }
        return enhancer;
    }
}

