/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.objectstores.dflt;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebugUtils;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.runtimes.dflt.objectstores.dflt.InMemoryPersistenceSessionFactory;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.ObjectStoreInstances;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.ObjectStorePersistedObjects;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.ObjectStorePersistedObjectsDefault;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.commands.InMemoryCreateObjectCommand;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.commands.InMemoryDestroyObjectCommand;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.commands.InMemorySaveObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.runtimes.dflt.runtime.persistence.PersistorUtil;
import org.apache.isis.runtimes.dflt.runtime.persistence.UnsupportedFindException;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.ObjectStore;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.apache.isis.runtimes.dflt.runtime.persistence.query.PersistenceQueryBuiltIn;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.AdapterManager;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionHydrator;
import org.apache.isis.runtimes.dflt.runtime.transaction.ObjectPersistenceException;
import org.apache.log4j.Logger;

public class InMemoryObjectStore
implements ObjectStore {
    private static final Logger LOG = Logger.getLogger(InMemoryObjectStore.class);
    protected ObjectStorePersistedObjects persistedObjects;

    public InMemoryObjectStore() {
        LOG.info((Object)"creating memory object store");
    }

    public String name() {
        return "In-Memory Object Store";
    }

    public void open() {
        InMemoryPersistenceSessionFactory inMemoryPersistenceSessionFactory = this.getInMemoryPersistenceSessionFactory();
        ObjectStorePersistedObjects objectStorePersistedObjects = this.persistedObjects = inMemoryPersistenceSessionFactory == null ? null : inMemoryPersistenceSessionFactory.getPersistedObjects();
        if (this.persistedObjects == null) {
            this.persistedObjects = inMemoryPersistenceSessionFactory != null ? inMemoryPersistenceSessionFactory.createPersistedObjects() : new ObjectStorePersistedObjectsDefault();
        } else {
            this.recreateAdapters();
        }
    }

    protected void recreateAdapters() {
        for (ObjectSpecification noSpec : this.persistedObjects.specifications()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("recreating adapters for: " + noSpec.getFullIdentifier()));
            }
            this.recreateAdapters(this.persistedObjects.instancesFor(noSpec));
        }
    }

    private void recreateAdapters(ObjectStoreInstances objectStoreInstances) {
        for (Oid oid : objectStoreInstances.getOids()) {
            ObjectAdapter existingAdapterLookedUpByOid;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("recreating adapter: oid=" + oid));
            }
            Object pojo = objectStoreInstances.getPojo(oid);
            ObjectAdapter existingAdapterLookedUpByPojo = this.getAdapterManager().getAdapterFor(pojo);
            if (existingAdapterLookedUpByPojo != null) {
                this.getAdapterManager().removeAdapter(existingAdapterLookedUpByPojo);
            }
            if ((existingAdapterLookedUpByOid = this.getAdapterManager().getAdapterFor(oid)) != null) {
                throw new IsisException("A mapping already exists for " + oid + ": " + existingAdapterLookedUpByOid);
            }
            ObjectAdapter recreatedAdapter = this.getHydrator().recreateAdapter(oid, pojo);
            Version version = objectStoreInstances.getVersion(oid);
            recreatedAdapter.setOptimisticLock(version);
        }
    }

    public void close() {
        InMemoryPersistenceSessionFactory inMemoryPersistenceSessionFactory = this.getInMemoryPersistenceSessionFactory();
        if (inMemoryPersistenceSessionFactory != null) {
            inMemoryPersistenceSessionFactory.attach(this.getPersistenceSession(), this.persistedObjects);
            this.persistedObjects = null;
        }
    }

    public boolean isFixturesInstalled() {
        return false;
    }

    public void reset() {
    }

    public void startTransaction() {
    }

    public void endTransaction() {
    }

    public void abortTransaction() {
    }

    public CreateObjectCommand createCreateObjectCommand(ObjectAdapter object) {
        return new InMemoryCreateObjectCommand(object, this.persistedObjects);
    }

    public SaveObjectCommand createSaveObjectCommand(ObjectAdapter object) {
        return new InMemorySaveObjectCommand(object, this.persistedObjects);
    }

    public DestroyObjectCommand createDestroyObjectCommand(ObjectAdapter object) {
        return new InMemoryDestroyObjectCommand(object, this.persistedObjects);
    }

    public void execute(List<PersistenceCommand> commands) throws ObjectPersistenceException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"execute commands");
        }
        for (PersistenceCommand command : commands) {
            command.execute(null);
        }
        LOG.info((Object)"end execution");
    }

    public ObjectAdapter getObject(Oid oid, ObjectSpecification hint) throws ObjectNotFoundException, ObjectPersistenceException {
        LOG.debug((Object)("getObject " + oid));
        ObjectStoreInstances ins = this.instancesFor(hint);
        ObjectAdapter object = ins.retrieveObject(oid);
        if (object == null) {
            throw new ObjectNotFoundException(oid);
        }
        this.setupReferencedObjects(object);
        return object;
    }

    public void resolveImmediately(ObjectAdapter adapter) throws ObjectPersistenceException {
        if (adapter.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
            LOG.debug((Object)("resolve " + adapter));
            this.setupReferencedObjects(adapter);
            PersistorUtil.start((ObjectAdapter)adapter, (ResolveState)ResolveState.RESOLVING);
            PersistorUtil.end((ObjectAdapter)adapter);
        } else {
            LOG.warn((Object)("resolveImmediately ignored, adapter's current state is: " + adapter.getResolveState() + " ; oid: " + adapter.getOid()));
        }
    }

    public void resolveField(ObjectAdapter object, ObjectAssociation field) throws ObjectPersistenceException {
        ObjectAdapter reference = field.get(object);
        PersistorUtil.start((ObjectAdapter)reference, (ResolveState)ResolveState.RESOLVING);
        PersistorUtil.end((ObjectAdapter)reference);
    }

    private void setupReferencedObjects(ObjectAdapter object) {
        this.setupReferencedObjects(object, new Vector());
    }

    private void setupReferencedObjects(ObjectAdapter adapter, Vector all) {
    }

    public ObjectAdapter[] getInstances(PersistenceQuery persistenceQuery) throws ObjectPersistenceException, UnsupportedFindException {
        if (!(persistenceQuery instanceof PersistenceQueryBuiltIn)) {
            throw new IllegalArgumentException(MessageFormat.format("Provided PersistenceQuery not supported; was {0}; the in-memory object store only supports {1}", persistenceQuery.getClass().getName(), PersistenceQueryBuiltIn.class.getName()));
        }
        PersistenceQueryBuiltIn builtIn = (PersistenceQueryBuiltIn)persistenceQuery;
        Vector<ObjectAdapter> instances = new Vector<ObjectAdapter>();
        ObjectSpecification spec = persistenceQuery.getSpecification();
        this.findInstances(spec, builtIn, instances);
        return this.toInstancesArray(instances);
    }

    public boolean hasInstances(ObjectSpecification spec) {
        if (this.instancesFor(spec).hasInstances()) {
            return true;
        }
        List subclasses = spec.subclasses();
        for (int i = 0; i < subclasses.size(); ++i) {
            if (!this.hasInstances((ObjectSpecification)subclasses.get(i))) continue;
            return true;
        }
        return false;
    }

    private void findInstances(ObjectSpecification spec, PersistenceQueryBuiltIn persistenceQuery, Vector<ObjectAdapter> foundInstances) {
        this.instancesFor(spec).findInstancesAndAdd(persistenceQuery, foundInstances);
        List subclasses = spec.subclasses();
        for (int i = 0; i < subclasses.size(); ++i) {
            this.findInstances((ObjectSpecification)subclasses.get(i), persistenceQuery, foundInstances);
        }
    }

    private ObjectAdapter[] toInstancesArray(Vector<ObjectAdapter> instances) {
        ObjectAdapter[] ins = new ObjectAdapter[instances.size()];
        for (int i = 0; i < ins.length; ++i) {
            ObjectAdapter object = instances.elementAt(i);
            this.setupReferencedObjects(object);
            if (object.getResolveState().canChangeTo(ResolveState.RESOLVING)) {
                PersistorUtil.start((ObjectAdapter)object, (ResolveState)ResolveState.RESOLVING);
                PersistorUtil.end((ObjectAdapter)object);
            }
            ins[i] = object;
        }
        return ins;
    }

    public Oid getOidForService(String name) {
        return this.persistedObjects.getService(name);
    }

    public void registerService(String name, Oid oid) {
        this.persistedObjects.registerService(name, oid);
    }

    private ObjectStoreInstances instancesFor(ObjectSpecification spec) {
        return this.persistedObjects.instancesFor(spec);
    }

    public String debugTitle() {
        return this.name();
    }

    public void debugData(DebugBuilder debug) {
        debug.appendTitle("Domain Objects");
        for (ObjectSpecification spec : this.persistedObjects.specifications()) {
            debug.appendln(spec.getFullIdentifier());
            ObjectStoreInstances instances = this.instancesFor(spec);
            instances.debugData(debug);
        }
        debug.unindent();
        debug.appendln();
    }

    private String debugCollectionGraph(ObjectAdapter collection, int level, Vector recursiveElements) {
        StringBuffer s = new StringBuffer();
        if (recursiveElements.contains(collection)) {
            s.append("*\n");
        } else {
            recursiveElements.addElement(collection);
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)collection);
            Iterator e = facet.iterator(collection);
            while (e.hasNext()) {
                ObjectAdapter element;
                this.indent(s, level);
                try {
                    element = (ObjectAdapter)e.next();
                }
                catch (ClassCastException ex) {
                    LOG.error((Object)ex);
                    return s.toString();
                }
                s.append(element);
                s.append(this.debugGraph(element, level + 1, recursiveElements));
            }
        }
        return s.toString();
    }

    private String debugGraph(ObjectAdapter object, int level, Vector recursiveElements) {
        if (level > 3) {
            return "...\n";
        }
        Vector elements = recursiveElements == null ? new Vector(25, 10) : recursiveElements;
        if (object.getSpecification().isCollection()) {
            return "\n" + this.debugCollectionGraph(object, level, elements);
        }
        return "\n" + this.debugObjectGraph(object, level, elements);
    }

    private String debugObjectGraph(ObjectAdapter object, int level, Vector recursiveElements) {
        StringBuffer s = new StringBuffer();
        recursiveElements.addElement(object);
        List fields = object.getSpecification().getAssociations();
        for (int i = 0; i < fields.size(); ++i) {
            ObjectAssociation field = (ObjectAssociation)fields.get(i);
            ObjectAdapter obj = field.get(object);
            String id = field.getId();
            this.indent(s, level);
            if (field.isOneToManyAssociation()) {
                s.append(id + ": \n" + this.debugCollectionGraph(obj, level + 1, recursiveElements));
                continue;
            }
            if (recursiveElements.contains(obj)) {
                s.append(id + ": " + obj + "*\n");
                continue;
            }
            s.append(id + ": " + obj);
            s.append(this.debugGraph(obj, level + 1, recursiveElements));
        }
        return s.toString();
    }

    private void indent(StringBuffer s, int level) {
        for (int indent = 0; indent < level; ++indent) {
            s.append(DebugUtils.indentString((int)4) + "|");
        }
        s.append(DebugUtils.indentString((int)4) + "+--");
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected PersistenceSessionHydrator getHydrator() {
        return this.getPersistenceSession();
    }

    protected InMemoryPersistenceSessionFactory getInMemoryPersistenceSessionFactory() {
        PersistenceSessionFactory persistenceSessionFactory = this.getPersistenceSession().getPersistenceSessionFactory();
        if (!(persistenceSessionFactory instanceof InMemoryPersistenceSessionFactory)) {
            return null;
        }
        return (InMemoryPersistenceSessionFactory)persistenceSessionFactory;
    }
}

