/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.objectstores.dflt;

import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.ObjectStoreInstances;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.ObjectStorePersistedObjects;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.ObjectStorePersistedObjectsDefault;
import org.apache.isis.runtimes.dflt.runtime.persistence.PersistenceSessionFactoryDelegate;
import org.apache.isis.runtimes.dflt.runtime.persistence.PersistenceSessionFactoryDelegating;
import org.apache.isis.runtimes.dflt.runtime.persistence.oidgenerator.simple.SimpleOidGenerator;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.OidGenerator;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;

public class InMemoryPersistenceSessionFactory
extends PersistenceSessionFactoryDelegating {
    private ObjectStorePersistedObjects persistedObjects;

    public InMemoryPersistenceSessionFactory(DeploymentType deploymentType, PersistenceSessionFactoryDelegate persistenceSessionFactoryDelegate) {
        super(deploymentType, persistenceSessionFactoryDelegate);
    }

    protected ObjectStorePersistedObjects getPersistedObjects() {
        return this.persistedObjects;
    }

    public PersistenceSession createPersistenceSession() {
        OidGenerator oidGenerator;
        PersistenceSession persistenceSession = super.createPersistenceSession();
        if (this.persistedObjects != null && (oidGenerator = persistenceSession.getOidGenerator()) instanceof SimpleOidGenerator) {
            SimpleOidGenerator simpleOidGenerator = (SimpleOidGenerator)oidGenerator;
            simpleOidGenerator.resetTo(this.persistedObjects.getOidGeneratorMemento());
        }
        return persistenceSession;
    }

    public ObjectStorePersistedObjects createPersistedObjects() {
        return new ObjectStorePersistedObjectsDefault();
    }

    public void attach(PersistenceSession persistenceSession, ObjectStorePersistedObjects persistedObjects) {
        OidGenerator oidGenerator = persistenceSession.getOidGenerator();
        if (oidGenerator instanceof SimpleOidGenerator) {
            SimpleOidGenerator simpleOidGenerator = (SimpleOidGenerator)oidGenerator;
            persistedObjects.saveOidGeneratorMemento(simpleOidGenerator.getMemento());
        }
        this.persistedObjects = persistedObjects;
    }

    protected void doShutdown() {
        if (this.persistedObjects != null) {
            for (ObjectStoreInstances inst : this.persistedObjects.instances()) {
                inst.shutdown();
            }
            this.persistedObjects.clear();
        }
    }
}

