/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.objectstores.dflt.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.version.SerialNumberVersion;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.runtimes.dflt.runtime.persistence.query.PersistenceQueryBuiltIn;
import org.apache.isis.runtimes.dflt.runtime.persistence.query.PersistenceQueryFindByTitle;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.AdapterManager;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionHydrator;

public class ObjectStoreInstances {
    private final Map<Oid, Object> pojoByOidMap = new HashMap<Oid, Object>();
    private final Map<Oid, String> titleByOidMap = new HashMap<Oid, String>();
    private final Map<Oid, SerialNumberVersion> versionByOidMap = new HashMap<Oid, SerialNumberVersion>();
    private final ObjectSpecification spec;

    public ObjectStoreInstances(ObjectSpecification spec) {
        this.spec = spec;
    }

    public Map<Oid, Object> getObjectInstances() {
        return this.pojoByOidMap;
    }

    public Set<Oid> getOids() {
        return Collections.unmodifiableSet(this.pojoByOidMap.keySet());
    }

    public Object getPojo(Oid oid) {
        return this.pojoByOidMap.get(oid);
    }

    public Version getVersion(Oid oid) {
        return (Version)this.versionByOidMap.get(oid);
    }

    public void shutdown() {
        this.pojoByOidMap.clear();
        this.titleByOidMap.clear();
        this.versionByOidMap.clear();
    }

    public void save(ObjectAdapter adapter) {
        this.pojoByOidMap.put(adapter.getOid(), adapter.getObject());
        this.titleByOidMap.put(adapter.getOid(), adapter.titleString().toLowerCase());
        SerialNumberVersion version = this.versionByOidMap.get(adapter.getOid());
        SerialNumberVersion nextVersion = this.nextVersion(version);
        this.versionByOidMap.put(adapter.getOid(), nextVersion);
        adapter.setOptimisticLock((Version)nextVersion);
    }

    private synchronized SerialNumberVersion nextVersion(SerialNumberVersion version) {
        long sequence = (version != null ? version.getSequence() : 0L) + 1L;
        return new SerialNumberVersion(sequence, this.getAuthenticationSession().getUserName(), new Date(Clock.getTime()));
    }

    public void remove(Oid oid) {
        this.pojoByOidMap.remove(oid);
        this.titleByOidMap.remove(oid);
        this.versionByOidMap.remove(oid);
    }

    public ObjectAdapter retrieveObject(Oid oid) {
        Object pojo = this.getObjectInstances().get(oid);
        if (pojo == null) {
            return null;
        }
        ObjectAdapter adapterLookedUpByPojo = this.getAdapterManager().getAdapterFor(pojo);
        if (adapterLookedUpByPojo != null) {
            return adapterLookedUpByPojo;
        }
        ObjectAdapter adapterLookedUpByOid = this.getAdapterManager().getAdapterFor(oid);
        if (adapterLookedUpByOid != null) {
            return adapterLookedUpByOid;
        }
        return this.getHydrator().recreateAdapter(oid, pojo);
    }

    public void findInstancesAndAdd(PersistenceQueryBuiltIn persistenceQuery, List<ObjectAdapter> foundInstances) {
        if (persistenceQuery instanceof PersistenceQueryFindByTitle) {
            for (Oid oid : this.titleByOidMap.keySet()) {
                String title = this.titleByOidMap.get(oid);
                if (!((PersistenceQueryFindByTitle)persistenceQuery).matches(title)) continue;
                ObjectAdapter adapter = this.retrieveObject(oid);
                foundInstances.add(adapter);
            }
            return;
        }
        for (ObjectAdapter element : this.elements()) {
            if (!persistenceQuery.matches(element)) continue;
            foundInstances.add(element);
        }
    }

    public int numberOfInstances() {
        return this.getObjectInstances().size();
    }

    public boolean hasInstances() {
        return this.numberOfInstances() > 0;
    }

    private List<ObjectAdapter> elements() {
        ArrayList<ObjectAdapter> v = new ArrayList<ObjectAdapter>(this.getObjectInstances().size());
        for (Oid oid : this.getObjectInstances().keySet()) {
            v.add(this.retrieveObject(oid));
        }
        return v;
    }

    public void debugData(DebugBuilder debug) {
        debug.indent();
        if (this.getObjectInstances().size() == 0) {
            debug.appendln("no instances");
        }
        for (Oid oid : this.getObjectInstances().keySet()) {
            String title = this.titleByOidMap.get(oid);
            Object object = this.getObjectInstances().get(oid);
            debug.appendln(oid.toString(), (Object)(object + " (" + title + ")"));
        }
        debug.appendln();
        debug.unindent();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected PersistenceSessionHydrator getHydrator() {
        return this.getPersistenceSession();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }
}

