/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.objectstores.dflt.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.ObjectStoreInstances;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.ObjectStorePersistedObjects;
import org.apache.isis.runtimes.dflt.runtime.persistence.oidgenerator.simple.SimpleOidGenerator;

public class ObjectStorePersistedObjectsDefault
implements ObjectStorePersistedObjects {
    private final Map<ObjectSpecification, ObjectStoreInstances> instancesBySpecMap = new HashMap<ObjectSpecification, ObjectStoreInstances>();
    private final Map<String, Oid> serviceOidByIdMap = new HashMap<String, Oid>();
    private SimpleOidGenerator.Memento oidGeneratorMemento;

    @Override
    public SimpleOidGenerator.Memento getOidGeneratorMemento() {
        return this.oidGeneratorMemento;
    }

    @Override
    public void saveOidGeneratorMemento(SimpleOidGenerator.Memento memento) {
        this.oidGeneratorMemento = memento;
    }

    @Override
    public Oid getService(String name) {
        return this.serviceOidByIdMap.get(name);
    }

    @Override
    public void registerService(String name, Oid oid) {
        Oid oidLookedUpByName = this.serviceOidByIdMap.get(name);
        if (oidLookedUpByName != null) {
            if (oidLookedUpByName.equals(oid)) {
                throw new IsisException("Already another service registered as name: " + name + " (existing Oid: " + oidLookedUpByName + ", " + "intended: " + oid + ")");
            }
        } else {
            this.serviceOidByIdMap.put(name, oid);
        }
    }

    @Override
    public ObjectStoreInstances instancesFor(ObjectSpecification spec) {
        ObjectStoreInstances ins = this.instancesBySpecMap.get(spec);
        if (ins == null) {
            ins = new ObjectStoreInstances(spec);
            this.instancesBySpecMap.put(spec, ins);
        }
        return ins;
    }

    @Override
    public Iterable<ObjectSpecification> specifications() {
        return this.instancesBySpecMap.keySet();
    }

    @Override
    public void clear() {
        this.instancesBySpecMap.clear();
    }

    @Override
    public Iterable<ObjectStoreInstances> instances() {
        return this.instancesBySpecMap.values();
    }
}

