/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.objectstores.dflt.internal.commands;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.ObjectStoreInstances;
import org.apache.isis.runtimes.dflt.objectstores.dflt.internal.ObjectStorePersistedObjects;
import org.apache.isis.runtimes.dflt.runtime.persistence.objectstore.transaction.PersistenceCommandAbstract;
import org.apache.isis.runtimes.dflt.runtime.transaction.ObjectPersistenceException;
import org.apache.log4j.Logger;

public abstract class AbstractInMemoryPersistenceCommand
extends PersistenceCommandAbstract {
    private static final Logger LOG = Logger.getLogger(AbstractInMemoryPersistenceCommand.class);
    private final ObjectStorePersistedObjects persistedObjects;

    public AbstractInMemoryPersistenceCommand(ObjectAdapter adapter, ObjectStorePersistedObjects persistedObjects) {
        super(adapter);
        this.persistedObjects = persistedObjects;
    }

    protected void save(ObjectAdapter adapter) throws ObjectPersistenceException {
        ObjectSpecification specification = adapter.getSpecification();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("   saving object " + adapter + " as instance of " + specification.getShortIdentifier()));
        }
        ObjectStoreInstances ins = this.instancesFor(specification);
        ins.save(adapter);
    }

    protected void destroy(ObjectAdapter adapter) {
        ObjectSpecification specification = adapter.getSpecification();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("   destroy object " + adapter + " as instance of " + specification.getShortIdentifier()));
        }
        ObjectStoreInstances ins = this.instancesFor(specification);
        ins.remove(adapter.getOid());
    }

    private ObjectStoreInstances instancesFor(ObjectSpecification spec) {
        return this.persistedObjects.instancesFor(spec);
    }
}

