/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.assertions.SMIMEAssertionTestElement;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedParser;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

class SMIMEAssertion {
    private static final Logger log = LoggingManager.getLoggerForShortName((String)SMIMEAssertionTestElement.class.getName());

    SMIMEAssertion() {
    }

    public static AssertionResult getResult(SMIMEAssertionTestElement testElement, SampleResult response, String name) {
        SMIMEAssertion.checkForBouncycastle();
        AssertionResult res = new AssertionResult(name);
        try {
            MimeMessage msg = null;
            int msgPos = testElement.getSpecificMessagePositionAsInt();
            if (msgPos < 0) {
                SampleResult[] subResults = response.getSubResults();
                int pos = subResults.length + msgPos;
                if (log.isDebugEnabled()) {
                    log.debug("Getting message number: " + pos + " of " + subResults.length);
                }
                msg = SMIMEAssertion.getMessageFromResponse(response, pos);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Getting message number: " + msgPos);
                }
                msg = SMIMEAssertion.getMessageFromResponse(response, msgPos);
            }
            SMIMESignedParser s = null;
            if (log.isDebugEnabled()) {
                log.debug("Content-type: " + msg.getContentType());
            }
            if (msg.isMimeType("multipart/signed")) {
                MimeMultipart multipart = (MimeMultipart)msg.getContent();
                s = new SMIMESignedParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), multipart);
            } else if (msg.isMimeType("application/pkcs7-mime") || msg.isMimeType("application/x-pkcs7-mime")) {
                s = new SMIMESignedParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), (Part)msg);
            }
            if (null != s) {
                log.debug("Found signature");
                if (testElement.isNotSigned()) {
                    res.setFailure(true);
                    res.setFailureMessage("Mime message is signed");
                } else if (testElement.isVerifySignature() || !testElement.isSignerNoCheck()) {
                    res = SMIMEAssertion.verifySignature(testElement, s, name);
                }
            } else {
                log.debug("Did not find signature");
                if (!testElement.isNotSigned()) {
                    res.setFailure(true);
                    res.setFailureMessage("Mime message is not signed");
                }
            }
        }
        catch (MessagingException e) {
            String msg = "Cannot parse mime msg: " + e.getMessage();
            log.warn(msg, (Throwable)e);
            res.setFailure(true);
            res.setFailureMessage(msg);
        }
        catch (CMSException e) {
            res.setFailure(true);
            res.setFailureMessage("Error reading the signature: " + e.getMessage());
        }
        catch (SMIMEException e) {
            res.setFailure(true);
            res.setFailureMessage("Cannot extract signed body part from signature: " + e.getMessage());
        }
        catch (IOException e) {
            log.error("Cannot read mime message content: " + e.getMessage(), (Throwable)e);
            res.setError(true);
            res.setFailureMessage(e.getMessage());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AssertionResult verifySignature(SMIMEAssertionTestElement testElement, SMIMESignedParser s, String name) throws CMSException {
        AssertionResult res = new AssertionResult(name);
        try {
            Iterator signerIt;
            block19: {
                block20: {
                    JcaX509CertificateHolder certFromFile;
                    Store certs = s.getCertificates();
                    SignerInformationStore signers = s.getSignerInfos();
                    signerIt = signers.getSigners().iterator();
                    if (!signerIt.hasNext()) break block19;
                    SignerInformation signer = (SignerInformation)signerIt.next();
                    Iterator certIt = certs.getMatches((Selector)signer.getSID()).iterator();
                    if (!certIt.hasNext()) break block20;
                    X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
                    if (testElement.isVerifySignature()) {
                        SignerInformationVerifier verifier = null;
                        try {
                            verifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert);
                        }
                        catch (OperatorCreationException e) {
                            log.error("Can't create a provider", (Throwable)e);
                        }
                        if (verifier == null || !signer.verify(verifier)) {
                            res.setFailure(true);
                            res.setFailureMessage("Signature is invalid");
                        }
                    }
                    if (testElement.isSignerCheckConstraints()) {
                        String issuer;
                        String subject;
                        List<String> emailFromCert;
                        String email;
                        BigInteger serialNbr;
                        StringBuilder failureMessage = new StringBuilder();
                        String serial = testElement.getSignerSerial();
                        if (!JOrphanUtils.isBlank((String)serial) && !(serialNbr = SMIMEAssertion.readSerialNumber(serial)).equals(cert.getSerialNumber())) {
                            res.setFailure(true);
                            failureMessage.append("Serial number ").append(serialNbr).append(" does not match serial from signer certificate: ").append(cert.getSerialNumber()).append("\n");
                        }
                        if (!JOrphanUtils.isBlank((String)(email = testElement.getSignerEmail())) && !(emailFromCert = SMIMEAssertion.getEmailFromCert(cert)).contains(email)) {
                            res.setFailure(true);
                            failureMessage.append("Email address \"").append(email).append("\" not present in signer certificate\n");
                        }
                        if ((subject = testElement.getSignerDn()).length() > 0) {
                            X500Name certPrincipal = cert.getSubject();
                            log.debug("DN from cert: " + certPrincipal.toString());
                            X500Name principal = new X500Name(subject);
                            log.debug("DN from assertion: " + principal.toString());
                            if (!principal.equals((Object)certPrincipal)) {
                                res.setFailure(true);
                                failureMessage.append("Distinguished name of signer certificate does not match \"").append(subject).append("\"\n");
                            }
                        }
                        if ((issuer = testElement.getIssuerDn()).length() > 0) {
                            X500Name issuerX500Name = cert.getIssuer();
                            log.debug("IssuerDN from cert: " + issuerX500Name.toString());
                            X500Name principal = new X500Name(issuer);
                            log.debug("IssuerDN from assertion: " + principal);
                            if (!principal.equals((Object)issuerX500Name)) {
                                res.setFailure(true);
                                failureMessage.append("Issuer distinguished name of signer certificate does not match \"").append(subject).append("\"\n");
                            }
                        }
                        if (failureMessage.length() > 0) {
                            res.setFailureMessage(failureMessage.toString());
                        }
                    }
                    if (!testElement.isSignerCheckByFile()) break block19;
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    BufferedInputStream inStream = null;
                    try {
                        inStream = new BufferedInputStream(new FileInputStream(testElement.getSignerCertFile()));
                        certFromFile = new JcaX509CertificateHolder((X509Certificate)cf.generateCertificate(inStream));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)inStream);
                    if (!certFromFile.equals((Object)cert)) {
                        res.setFailure(true);
                        res.setFailureMessage("Signer certificate does not match certificate " + testElement.getSignerCertFile());
                    }
                    break block19;
                }
                res.setFailure(true);
                res.setFailureMessage("No signer certificate found in signature");
            }
            if (signerIt.hasNext()) {
                log.warn("SMIME message contains multiple signers! Checking multiple signers is not supported.");
            }
        }
        catch (GeneralSecurityException e) {
            log.error(e.getMessage(), (Throwable)e);
            res.setError(true);
            res.setFailureMessage(e.getMessage());
        }
        catch (FileNotFoundException e) {
            res.setFailure(true);
            res.setFailureMessage("certificate file not found: " + e.getMessage());
        }
        return res;
    }

    private static MimeMessage getMessageFromResponse(SampleResult response, int messageNumber) throws MessagingException {
        SampleResult[] subResults = response.getSubResults();
        if (messageNumber >= subResults.length || messageNumber < 0) {
            throw new MessagingException("Message number not present in results: " + messageNumber);
        }
        SampleResult sampleResult = subResults[messageNumber];
        if (log.isDebugEnabled()) {
            log.debug("Bytes: " + sampleResult.getBytesAsLong() + " CT: " + sampleResult.getContentType());
        }
        byte[] data = sampleResult.getResponseData();
        Session session = Session.getDefaultInstance((Properties)new Properties());
        MimeMessage msg = new MimeMessage(session, (InputStream)new ByteArrayInputStream(data));
        log.debug("msg.getSize() = " + msg.getSize());
        return msg;
    }

    private static BigInteger readSerialNumber(String serialString) {
        if (serialString.startsWith("0x") || serialString.startsWith("0X")) {
            return new BigInteger(serialString.substring(2), 16);
        }
        return new BigInteger(serialString);
    }

    private static List<String> getEmailFromCert(X509CertificateHolder cert) throws CertificateException {
        ArrayList<String> res = new ArrayList<String>();
        X500Name subject = cert.getSubject();
        for (RDN emails : subject.getRDNs(BCStyle.EmailAddress)) {
            for (AttributeTypeAndValue emailAttr : emails.getTypesAndValues()) {
                log.debug("Add email from RDN: " + IETFUtils.valueToString((ASN1Encodable)emailAttr.getValue()));
                res.add(IETFUtils.valueToString((ASN1Encodable)emailAttr.getValue()));
            }
        }
        Extension subjectAlternativeNames = cert.getExtension(Extension.subjectAlternativeName);
        if (subjectAlternativeNames != null) {
            for (GeneralName name : GeneralNames.getInstance((Object)subjectAlternativeNames.getParsedValue()).getNames()) {
                if (name.getTagNo() != 1) continue;
                String email = IETFUtils.valueToString((ASN1Encodable)name.getName());
                log.debug("Add email from subjectAlternativeName: " + email);
                res.add(email);
            }
        }
        return res;
    }

    private static void checkForBouncycastle() {
        if (null == Security.getProvider("BC")) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

